/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.StatisticBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.StatisticPostgresSQLProvider;
import org.apache.gravitino.storage.relational.po.StatisticPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class StatisticSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, StatisticBaseSQLProvider> STATISTIC_SQL_PROVIDERS = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new StatisticH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new StatisticMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new StatisticPostgresSQLProvider());

    public static StatisticBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return STATISTIC_SQL_PROVIDERS.get((Object)jdbcBackendType);
    }

    public static String batchInsertStatisticPOsOnDuplicateKeyUpdate(@Param(value="statisticPOs") List<StatisticPO> statisticPOs) {
        return StatisticSQLProviderFactory.getProvider().batchInsertStatisticPOsOnDuplicateKeyUpdate(statisticPOs);
    }

    public static String batchDeleteStatisticPOs(@Param(value="entityId") Long entityId, @Param(value="statisticNames") List<String> statisticNames) {
        return StatisticSQLProviderFactory.getProvider().batchDeleteStatisticPOs(entityId, statisticNames);
    }

    public static String softDeleteStatisticsByEntityId(@Param(value="entityId") Long entityId) {
        return StatisticSQLProviderFactory.getProvider().softDeleteStatisticsByEntityId(entityId);
    }

    public static String listStatisticPOsByEntityId(@Param(value="metalakeId") Long metalakeId, @Param(value="entityId") Long entityId) {
        return StatisticSQLProviderFactory.getProvider().listStatisticPOsByEntityId(metalakeId, entityId);
    }

    public static String softDeleteStatisticsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return StatisticSQLProviderFactory.getProvider().softDeleteStatisticsByMetalakeId(metalakeId);
    }

    public static String softDeleteStatisticsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return StatisticSQLProviderFactory.getProvider().softDeleteStatisticsByCatalogId(catalogId);
    }

    public static String softDeleteStatisticsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return StatisticSQLProviderFactory.getProvider().softDeleteStatisticsBySchemaId(schemaId);
    }

    public static String deleteStatisticsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return StatisticSQLProviderFactory.getProvider().deleteStatisticsByLegacyTimeline(legacyTimeline, limit);
    }

    static class StatisticH2Provider
    extends StatisticBaseSQLProvider {
        StatisticH2Provider() {
        }
    }

    static class StatisticMySQLProvider
    extends StatisticBaseSQLProvider {
        StatisticMySQLProvider() {
        }
    }
}

