/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.hudi.backend.hms;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.catalog.lakehouse.hudi.HudiSchema;
import org.apache.gravitino.catalog.lakehouse.hudi.HudiTable;
import org.apache.gravitino.catalog.lakehouse.hudi.backend.hms.HudiHMSSchema;
import org.apache.gravitino.catalog.lakehouse.hudi.backend.hms.HudiHMSTable;
import org.apache.gravitino.catalog.lakehouse.hudi.ops.HudiCatalogBackendOps;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.hive.CachedClientPool;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HudiHMSBackendOps
implements HudiCatalogBackendOps {
    private static final Logger LOG = LoggerFactory.getLogger(HudiHMSBackendOps.class);
    private static final Map<String, String> CONFIG_CONVERTER = ImmutableMap.of((Object)"uri", (Object)"hive.metastore.uris");
    private static final String HUDI_PACKAGE_PREFIX = "org.apache.hudi";
    private String catalogName;
    @VisibleForTesting
    CachedClientPool clientPool;

    @Override
    public void initialize(Map<String, String> properties) {
        Properties clientProperties = new Properties();
        HashMap byPassConfigs = Maps.newHashMap();
        HashMap convertedConfigs = Maps.newHashMap();
        properties.forEach((key, value) -> {
            if (key.startsWith("gravitino.bypass.")) {
                byPassConfigs.put(key.substring("gravitino.bypass.".length()), value);
            } else if (CONFIG_CONVERTER.containsKey(key)) {
                convertedConfigs.put(CONFIG_CONVERTER.get(key), value);
            } else {
                convertedConfigs.put(key, value);
            }
        });
        byPassConfigs.forEach(clientProperties::setProperty);
        convertedConfigs.forEach(clientProperties::setProperty);
        this.catalogName = properties.getOrDefault("default.catalog", "hive");
        String catalogKey = "hudi-" + properties.getOrDefault("catalogId", "0");
        this.clientPool = new CachedClientPool(catalogKey, clientProperties, properties);
        LOG.info("Hudi HMS Backend Ops initialized with properties: {}", properties);
    }

    @Override
    public HudiSchema loadSchema(NameIdentifier schemaIdent) throws NoSuchSchemaException {
        try {
            Schema database = (Schema)this.clientPool.run(client -> client.getDatabase(this.catalogName, schemaIdent.name()));
            return HudiHMSSchema.builder().buildFromSchema(database);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        try {
            return (NameIdentifier[])this.clientPool.run(c -> (NameIdentifier[])c.getAllDatabases(this.catalogName).stream().map(db -> NameIdentifier.of((Namespace)namespace, (String)db)).toArray(NameIdentifier[]::new));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HudiHMSSchema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public HudiHMSSchema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])namespace.levels());
        if (!this.schemaExists(schemaIdent)) {
            throw new NoSuchSchemaException("Schema (database) does not exist %s", new Object[]{namespace});
        }
        try {
            return (NameIdentifier[])this.clientPool.run(c -> {
                List allTables = c.getAllTables(this.catalogName, schemaIdent.name());
                return (NameIdentifier[])c.getTableObjectsByName(this.catalogName, schemaIdent.name(), allTables).stream().filter(this::checkHudiTable).map(t -> NameIdentifier.of((Namespace)namespace, (String)t.name())).toArray(NameIdentifier[]::new);
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public HudiTable loadTable(NameIdentifier tableIdent) throws NoSuchTableException {
        NameIdentifier schemaIdent = NameIdentifier.of((String[])tableIdent.namespace().levels());
        try {
            Table table = (Table)this.clientPool.run(client -> client.getTable(this.catalogName, schemaIdent.name(), tableIdent.name()));
            if (!this.checkHudiTable(table)) {
                throw new NoSuchTableException("Table %s is not a Hudi table in Hive Metastore", new Object[]{tableIdent.name()});
            }
            return HudiHMSTable.builder().withBackendTable(table).build();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public HudiHMSTable createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public HudiHMSTable alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean dropTable(NameIdentifier ident) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void close() {
        if (this.clientPool != null) {
            this.clientPool.close();
            this.clientPool = null;
        }
    }

    private boolean checkHudiTable(Table table) {
        String inputFormat = (String)table.properties().get("input-format");
        return inputFormat != null && inputFormat.startsWith(HUDI_PACKAGE_PREFIX);
    }
}

