/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.data.serializer.VersionedSerializer;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.index.IndexFileMeta09Serializer;
import org.apache.paimon.index.IndexFileMetaSerializer;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFileMeta08Serializer;
import org.apache.paimon.io.DataFileMeta09Serializer;
import org.apache.paimon.io.DataFileMeta10LegacySerializer;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.io.IndexIncrement;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.utils.IOExceptionSupplier;
import org.apache.paimon.utils.SerializationUtils;

public class CommitMessageSerializer
implements VersionedSerializer<CommitMessage> {
    private static final int CURRENT_VERSION = 7;
    private final DataFileMetaSerializer dataFileSerializer = new DataFileMetaSerializer();
    private final IndexFileMetaSerializer indexEntrySerializer = new IndexFileMetaSerializer();
    private DataFileMeta10LegacySerializer dataFileMeta10LegacySerializer;
    private DataFileMeta09Serializer dataFile09Serializer;
    private DataFileMeta08Serializer dataFile08Serializer;
    private IndexFileMeta09Serializer indexEntry09Serializer;

    public int getVersion() {
        return 7;
    }

    public byte[] serialize(CommitMessage obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)out);
        this.serialize(obj, (DataOutputView)view);
        return out.toByteArray();
    }

    public void serializeList(List<CommitMessage> list, DataOutputView view) throws IOException {
        view.writeInt(list.size());
        for (CommitMessage commitMessage : list) {
            this.serialize(commitMessage, view);
        }
    }

    private void serialize(CommitMessage obj, DataOutputView view) throws IOException {
        CommitMessageImpl message = (CommitMessageImpl)obj;
        SerializationUtils.serializeBinaryRow(obj.partition(), view);
        view.writeInt(obj.bucket());
        Integer totalBuckets = obj.totalBuckets();
        if (totalBuckets != null) {
            view.writeBoolean(true);
            view.writeInt(totalBuckets.intValue());
        } else {
            view.writeBoolean(false);
        }
        this.dataFileSerializer.serializeList(message.newFilesIncrement().newFiles(), view);
        this.dataFileSerializer.serializeList(message.newFilesIncrement().deletedFiles(), view);
        this.dataFileSerializer.serializeList(message.newFilesIncrement().changelogFiles(), view);
        this.dataFileSerializer.serializeList(message.compactIncrement().compactBefore(), view);
        this.dataFileSerializer.serializeList(message.compactIncrement().compactAfter(), view);
        this.dataFileSerializer.serializeList(message.compactIncrement().changelogFiles(), view);
        this.indexEntrySerializer.serializeList(message.indexIncrement().newIndexFiles(), view);
        this.indexEntrySerializer.serializeList(message.indexIncrement().deletedIndexFiles(), view);
    }

    public CommitMessage deserialize(int version, byte[] serialized) throws IOException {
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        return this.deserialize(version, (DataInputView)view);
    }

    public List<CommitMessage> deserializeList(int version, DataInputView view) throws IOException {
        int length = view.readInt();
        ArrayList<CommitMessage> list = new ArrayList<CommitMessage>(length);
        for (int i = 0; i < length; ++i) {
            list.add(this.deserialize(version, view));
        }
        return list;
    }

    private CommitMessage deserialize(int version, DataInputView view) throws IOException {
        IOExceptionSupplier<List<DataFileMeta>> fileDeserializer = this.fileDeserializer(version, view);
        IOExceptionSupplier<List<IndexFileMeta>> indexEntryDeserializer = this.indexEntryDeserializer(version, view);
        return new CommitMessageImpl(SerializationUtils.deserializeBinaryRow(view), view.readInt(), version >= 7 && view.readBoolean() ? Integer.valueOf(view.readInt()) : null, new DataIncrement(fileDeserializer.get(), fileDeserializer.get(), fileDeserializer.get()), new CompactIncrement(fileDeserializer.get(), fileDeserializer.get(), fileDeserializer.get()), new IndexIncrement(indexEntryDeserializer.get(), version <= 2 ? Collections.emptyList() : indexEntryDeserializer.get()));
    }

    private IOExceptionSupplier<List<DataFileMeta>> fileDeserializer(int version, DataInputView view) {
        if (version >= 6) {
            return () -> this.dataFileSerializer.deserializeList(view);
        }
        if (version == 4 || version == 5) {
            if (this.dataFileMeta10LegacySerializer == null) {
                this.dataFileMeta10LegacySerializer = new DataFileMeta10LegacySerializer();
            }
            return () -> this.dataFileMeta10LegacySerializer.deserializeList(view);
        }
        if (version == 3) {
            if (this.dataFile09Serializer == null) {
                this.dataFile09Serializer = new DataFileMeta09Serializer();
            }
            return () -> this.dataFile09Serializer.deserializeList(view);
        }
        if (this.dataFile08Serializer == null) {
            this.dataFile08Serializer = new DataFileMeta08Serializer();
        }
        return () -> this.dataFile08Serializer.deserializeList(view);
    }

    private IOExceptionSupplier<List<IndexFileMeta>> indexEntryDeserializer(int version, DataInputView view) {
        if (version >= 5) {
            return () -> this.indexEntrySerializer.deserializeList(view);
        }
        if (this.indexEntry09Serializer == null) {
            this.indexEntry09Serializer = new IndexFileMeta09Serializer();
        }
        return () -> this.indexEntry09Serializer.deserializeList(view);
    }
}

