/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon.storage;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.gravitino.connector.PropertyEntry;

public class PaimonOSSFileSystemConfig
extends Config {
    public static final String OSS_ENDPOINT = "fs.oss.endpoint";
    public static final String OSS_ACCESS_KEY = "fs.oss.accessKeyId";
    public static final String OSS_SECRET_KEY = "fs.oss.accessKeySecret";
    public static final ConfigEntry<String> PAIMON_OSS_ENDPOINT_ENTRY = new ConfigBuilder("fs.oss.endpoint").doc("The endpoint of the Aliyun oss").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> PAIMON_OSS_ACCESS_KEY_ENTRY = new ConfigBuilder("fs.oss.accessKeyId").doc("The access key of the Aliyun oss").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> PAIMON_OSS_SECRET_KEY_ENTRY = new ConfigBuilder("fs.oss.accessKeySecret").doc("The secret key of the Aliyun oss").version("0.7.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final Map<String, PropertyEntry<?>> OSS_FILESYSTEM_PROPERTY_ENTRIES = new ImmutableMap.Builder().put((Object)"fs.oss.endpoint", (Object)PropertyEntry.stringOptionalPropertyEntry((String)"fs.oss.endpoint", (String)"The endpoint of the Aliyun oss", (boolean)false, null, (boolean)false)).put((Object)"fs.oss.accessKeyId", (Object)PropertyEntry.stringOptionalPropertyEntry((String)"fs.oss.accessKeyId", (String)"The access key of the Aliyun oss", (boolean)false, null, (boolean)false)).put((Object)"fs.oss.accessKeySecret", (Object)PropertyEntry.stringOptionalPropertyEntry((String)"fs.oss.accessKeySecret", (String)"The secret key of the Aliyun oss", (boolean)false, null, (boolean)false)).build();

    public PaimonOSSFileSystemConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }

    public String getOSSEndpoint() {
        return (String)this.get(PAIMON_OSS_ENDPOINT_ENTRY);
    }

    public String getOSSAccessKey() {
        return (String)this.get(PAIMON_OSS_ACCESS_KEY_ENTRY);
    }

    public String getOSSSecretKey() {
        return (String)this.get(PAIMON_OSS_SECRET_KEY_ENTRY);
    }
}

