/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.code.asm;

import com.googlecode.aviator.parser.AviatorClassLoader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;

public class ClassDefiner {
    private static final Object[] EMPTY_OBJS = new Object[0];
    private static MethodHandle DEFINE_CLASS_HANDLE;
    public static final boolean IS_JDK7;
    public static final boolean IS_IBM_SDK;
    private static boolean preferClassLoader;
    private static int errorTimes;

    private static boolean isIBMJdk() {
        String vendor = System.getProperty("java.vendor");
        try {
            return vendor != null && vendor.toLowerCase().contains("ibm corporation");
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean isJDK7() {
        String version = System.getProperty("java.version");
        try {
            return version != null && version.startsWith("1.7");
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static final Class<?> defineClass(String className, Class<?> clazz, byte[] bytes, AviatorClassLoader classLoader, boolean forceClassLoader) throws NoSuchFieldException, IllegalAccessException {
        if (!preferClassLoader && !forceClassLoader && DEFINE_CLASS_HANDLE != null) {
            try {
                Class defineClass = DEFINE_CLASS_HANDLE.invokeExact(clazz, bytes, EMPTY_OBJS);
                return defineClass;
            }
            catch (Throwable e) {
                if (errorTimes++ > 10000) {
                    preferClassLoader = true;
                }
                return ClassDefiner.defineClassByClassLoader(className, bytes, classLoader);
            }
        }
        return ClassDefiner.defineClassByClassLoader(className, bytes, classLoader);
    }

    public static Class<?> defineClassByClassLoader(String className, byte[] bytes, AviatorClassLoader classLoader) {
        return classLoader.defineClass(className, bytes);
    }

    static {
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            if (clazz != null) {
                Field f = clazz.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                Object unsafe = f.get(null);
                MethodHandle methodHandle = MethodHandles.lookup().findVirtual(clazz, "defineAnonymousClass", MethodType.methodType(Class.class, Class.class, byte[].class, Object[].class));
                if (methodHandle != null) {
                    methodHandle = methodHandle.bindTo(unsafe);
                }
                DEFINE_CLASS_HANDLE = methodHandle;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IS_JDK7 = ClassDefiner.isJDK7();
        IS_IBM_SDK = ClassDefiner.isIBMJdk();
        preferClassLoader = Boolean.valueOf(System.getProperty("aviator.preferClassloaderDefiner", String.valueOf(IS_JDK7 || IS_IBM_SDK)));
        errorTimes = 0;
    }
}

