/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.writer;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.parquet.ColumnConfigParser;
import org.apache.paimon.format.parquet.writer.ParquetBuilder;
import org.apache.paimon.format.parquet.writer.ParquetRowDataBuilder;
import org.apache.paimon.options.Options;
import org.apache.paimon.shade.org.apache.parquet.column.ParquetProperties;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ParquetWriter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.paimon.shade.org.apache.parquet.io.OutputFile;
import org.apache.paimon.types.RowType;

public class RowDataParquetBuilder
implements ParquetBuilder<InternalRow> {
    private final RowType rowType;
    private final Configuration conf;

    public RowDataParquetBuilder(RowType rowType, Options options) {
        this.rowType = rowType;
        this.conf = new Configuration(false);
        options.toMap().forEach((arg_0, arg_1) -> ((Configuration)this.conf).set(arg_0, arg_1));
    }

    @Override
    public ParquetWriter<InternalRow> createWriter(OutputFile out, String compression) throws IOException {
        ParquetRowDataBuilder builder = (ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)((ParquetRowDataBuilder)new ParquetRowDataBuilder(out, this.rowType).withConf(this.conf)).withCompressionCodec(CompressionCodecName.fromConf(this.getCompression(compression)))).withRowGroupSize(this.conf.getLong("parquet.block.size", 0x8000000L))).withPageSize(this.conf.getInt("parquet.page.size", 0x100000))).withPageRowCountLimit(this.conf.getInt("parquet.page.row.count.limit", 20000))).withDictionaryPageSize(this.conf.getInt("parquet.dictionary.page.size", 0x100000))).withMaxPaddingSize(this.conf.getInt("parquet.writer.max-padding", 0x800000))).withDictionaryEncoding(this.conf.getBoolean("parquet.enable.dictionary", true))).withValidation(this.conf.getBoolean("parquet.validation", false))).withWriterVersion(ParquetProperties.WriterVersion.fromString(this.conf.get("parquet.writer.version", ParquetProperties.DEFAULT_WRITER_VERSION.toString())))).withBloomFilterEnabled(this.conf.getBoolean("parquet.bloom.filter.enabled", false));
        new ColumnConfigParser().withColumnConfig("parquet.enable.dictionary", key -> this.conf.getBoolean(key, false), builder::withDictionaryEncoding).withColumnConfig("parquet.bloom.filter.enabled", key -> this.conf.getBoolean(key, false), builder::withBloomFilterEnabled).withColumnConfig("parquet.bloom.filter.expected.ndv", key -> this.conf.getLong(key, -1L), builder::withBloomFilterNDV).withColumnConfig("parquet.bloom.filter.fpp", key -> this.conf.getDouble(key, 0.01), builder::withBloomFilterFPP).parseConfig(this.conf);
        return builder.build();
    }

    public String getCompression(String compression) {
        return this.conf.get("parquet.compression", compression);
    }
}

