/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.connector.BasePropertiesMetadata;
import org.apache.gravitino.connector.PropertiesMetadata;
import org.apache.gravitino.connector.PropertyEntry;

@Evolving
public abstract class BaseCatalogPropertiesMetadata
extends BasePropertiesMetadata {
    public static final PropertiesMetadata BASIC_CATALOG_PROPERTIES_METADATA = new BaseCatalogPropertiesMetadata(){

        @Override
        protected Map<String, PropertyEntry<?>> specificPropertyEntries() {
            return Collections.emptyMap();
        }
    };
    private static final Map<String, PropertyEntry<?>> BASIC_CATALOG_PROPERTY_ENTRIES = Maps.uniqueIndex((Iterable)ImmutableList.of(PropertyEntry.stringImmutablePropertyEntry("package", "The path of the catalog-related classes and resources", false, null, false, false), PropertyEntry.stringImmutablePropertyEntry("ops-impl", "The classname of custom catalog operation to replace the default implementation", false, null, false, false), PropertyEntry.stringImmutablePropertyEntry("authorization-provider", "The name of the authorization provider for Gravitino", false, null, false, false), PropertyEntry.enumPropertyEntry("cloud.name", "The cloud that the catalog is running on", false, false, Catalog.CloudName.class, null, false, false), PropertyEntry.stringOptionalPropertyEntry("cloud.region-code", "The region code of the cloud that the catalog is running on", false, null, false), PropertyEntry.booleanReservedPropertyEntry("in-use", "The property indicating the catalog is in use", true, false)), PropertyEntry::getName);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, PropertyEntry<?>> propertyEntries() {
        if (this.propertyEntries == null) {
            BaseCatalogPropertiesMetadata baseCatalogPropertiesMetadata = this;
            synchronized (baseCatalogPropertiesMetadata) {
                if (this.propertyEntries == null) {
                    ImmutableMap.Builder builder = ImmutableMap.builder();
                    Map<String, PropertyEntry<?>> properties = this.specificPropertyEntries();
                    builder.putAll(properties);
                    BASIC_PROPERTY_ENTRIES.forEach((name, entry) -> {
                        Preconditions.checkArgument((!properties.containsKey(name) ? 1 : 0) != 0, (Object)("Property metadata already exists: " + name));
                        builder.put(name, entry);
                    });
                    BASIC_CATALOG_PROPERTY_ENTRIES.forEach((name, entry) -> {
                        Preconditions.checkArgument((!properties.containsKey(name) ? 1 : 0) != 0, (Object)("Property metadata already exists: " + name));
                        builder.put(name, entry);
                    });
                    this.propertyEntries = builder.build();
                }
            }
        }
        return this.propertyEntries;
    }
}

