/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHookManager {
    private static final ShutdownHookManager MGR = new ShutdownHookManager();
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownHookManager.class);
    private static final long TIMEOUT_DEFAULT = 10L;
    private static final TimeUnit TIME_UNIT_DEFAULT = TimeUnit.SECONDS;
    private static final ExecutorService EXECUTOR = HadoopExecutors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).build());
    private final Set<HookEntry> hooks = Collections.synchronizedSet(new HashSet());
    private AtomicBoolean shutdownInProgress = new AtomicBoolean(false);

    public static ShutdownHookManager get() {
        return MGR;
    }

    private ShutdownHookManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<HookEntry> getShutdownHooksInOrder() {
        ArrayList<HookEntry> list;
        Set<HookEntry> set = ShutdownHookManager.MGR.hooks;
        synchronized (set) {
            list = new ArrayList<HookEntry>(ShutdownHookManager.MGR.hooks);
        }
        Collections.sort(list, new Comparator<HookEntry>(){

            @Override
            public int compare(HookEntry o1, HookEntry o2) {
                return o2.priority - o1.priority;
            }
        });
        return list;
    }

    public void addShutdownHook(Runnable shutdownHook, int priority) {
        if (shutdownHook == null) {
            throw new IllegalArgumentException("shutdownHook cannot be NULL");
        }
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot add a shutdownHook");
        }
        this.hooks.add(new HookEntry(shutdownHook, priority));
    }

    public void addShutdownHook(Runnable shutdownHook, int priority, long timeout, TimeUnit unit) {
        if (shutdownHook == null) {
            throw new IllegalArgumentException("shutdownHook cannot be NULL");
        }
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot add a shutdownHook");
        }
        this.hooks.add(new HookEntry(shutdownHook, priority, timeout, unit));
    }

    public boolean removeShutdownHook(Runnable shutdownHook) {
        if (this.shutdownInProgress.get()) {
            throw new IllegalStateException("Shutdown in progress, cannot remove a shutdownHook");
        }
        return this.hooks.remove(new HookEntry(shutdownHook, 0));
    }

    public boolean hasShutdownHook(Runnable shutdownHook) {
        return this.hooks.contains(new HookEntry(shutdownHook, 0));
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress.get();
    }

    public void clearShutdownHooks() {
        this.hooks.clear();
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    MGR.shutdownInProgress.set(true);
                    for (HookEntry entry : MGR.getShutdownHooksInOrder()) {
                        Future<?> future = EXECUTOR.submit(entry.getHook());
                        try {
                            future.get(entry.getTimeout(), entry.getTimeUnit());
                        }
                        catch (TimeoutException ex) {
                            future.cancel(true);
                            LOG.warn("ShutdownHook '" + entry.getHook().getClass().getSimpleName() + "' timeout, " + ex.toString(), (Throwable)ex);
                        }
                        catch (Throwable ex) {
                            LOG.warn("ShutdownHook '" + entry.getHook().getClass().getSimpleName() + "' failed, " + ex.toString(), ex);
                        }
                    }
                    try {
                        EXECUTOR.shutdown();
                        if (!EXECUTOR.awaitTermination(10L, TIME_UNIT_DEFAULT)) {
                            LOG.error("ShutdownHookManger shutdown forcefully.");
                            EXECUTOR.shutdownNow();
                        }
                        LOG.debug("ShutdownHookManger complete shutdown.");
                    }
                    catch (InterruptedException ex) {
                        LOG.error("ShutdownHookManger interrupted while waiting for termination.", (Throwable)ex);
                        EXECUTOR.shutdownNow();
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }
        catch (IllegalStateException ex) {
            LOG.warn("Failed to add the ShutdownHook", (Throwable)ex);
        }
    }

    static class HookEntry {
        private final Runnable hook;
        private final int priority;
        private final long timeout;
        private final TimeUnit unit;

        HookEntry(Runnable hook, int priority) {
            this(hook, priority, 10L, TIME_UNIT_DEFAULT);
        }

        HookEntry(Runnable hook, int priority, long timeout, TimeUnit unit) {
            this.hook = hook;
            this.priority = priority;
            this.timeout = timeout;
            this.unit = unit;
        }

        public int hashCode() {
            return this.hook.hashCode();
        }

        public boolean equals(Object obj) {
            boolean eq = false;
            if (obj != null && obj instanceof HookEntry) {
                eq = this.hook == ((HookEntry)obj).hook;
            }
            return eq;
        }

        Runnable getHook() {
            return this.hook;
        }

        int getPriority() {
            return this.priority;
        }

        long getTimeout() {
            return this.timeout;
        }

        TimeUnit getTimeUnit() {
            return this.unit;
        }
    }
}

