/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.utils.Preconditions;

@Public
public final class LocalZoneTimestamp
implements Comparable<LocalZoneTimestamp>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long millisecond;
    private final int nanoOfMillisecond;

    private LocalZoneTimestamp(long millisecond, int nanoOfMillisecond) {
        Preconditions.checkArgument((nanoOfMillisecond >= 0 && nanoOfMillisecond <= 999999 ? 1 : 0) != 0);
        this.millisecond = millisecond;
        this.nanoOfMillisecond = nanoOfMillisecond;
    }

    public long getMillisecond() {
        return this.millisecond;
    }

    public int getNanoOfMillisecond() {
        return this.nanoOfMillisecond;
    }

    public Timestamp toSQLTimestamp() {
        return Timestamp.from(this.toInstant());
    }

    public LocalZoneTimestamp toMillisTimestamp() {
        return LocalZoneTimestamp.fromEpochMillis(this.millisecond);
    }

    public Instant toInstant() {
        long epochSecond = this.millisecond / 1000L;
        int milliOfSecond = (int)(this.millisecond % 1000L);
        if (milliOfSecond < 0) {
            --epochSecond;
            milliOfSecond += 1000;
        }
        long nanoAdjustment = milliOfSecond * 1000000 + this.nanoOfMillisecond;
        return Instant.ofEpochSecond(epochSecond, nanoAdjustment);
    }

    public long toMicros() {
        long micros = Math.multiplyExact(this.millisecond, 1000L);
        return micros + (long)this.nanoOfMillisecond / 1000L;
    }

    @Override
    public int compareTo(LocalZoneTimestamp that) {
        int cmp = Long.compare(this.millisecond, that.millisecond);
        if (cmp == 0) {
            cmp = this.nanoOfMillisecond - that.nanoOfMillisecond;
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocalZoneTimestamp)) {
            return false;
        }
        LocalZoneTimestamp that = (LocalZoneTimestamp)obj;
        return this.millisecond == that.millisecond && this.nanoOfMillisecond == that.nanoOfMillisecond;
    }

    public String toString() {
        return this.toSQLTimestamp().toLocalDateTime().toString();
    }

    public int hashCode() {
        int ret = (int)this.millisecond ^ (int)(this.millisecond >> 32);
        return 31 * ret + this.nanoOfMillisecond;
    }

    public static LocalZoneTimestamp now() {
        return LocalZoneTimestamp.fromInstant(Instant.now());
    }

    public static LocalZoneTimestamp fromEpochMillis(long milliseconds) {
        return new LocalZoneTimestamp(milliseconds, 0);
    }

    public static LocalZoneTimestamp fromEpochMillis(long milliseconds, int nanosOfMillisecond) {
        return new LocalZoneTimestamp(milliseconds, nanosOfMillisecond);
    }

    public static LocalZoneTimestamp fromSQLTimestamp(Timestamp timestamp) {
        return LocalZoneTimestamp.fromInstant(timestamp.toInstant());
    }

    public static LocalZoneTimestamp fromInstant(Instant instant) {
        long epochSecond = instant.getEpochSecond();
        int nanoSecond = instant.getNano();
        long millisecond = epochSecond * 1000L + (long)(nanoSecond / 1000000);
        int nanoOfMillisecond = nanoSecond % 1000000;
        return new LocalZoneTimestamp(millisecond, nanoOfMillisecond);
    }

    public static LocalZoneTimestamp fromMicros(long micros) {
        long mills = Math.floorDiv(micros, 1000L);
        long nanos = (micros - mills * 1000L) * 1000L;
        return LocalZoneTimestamp.fromEpochMillis(mills, (int)nanos);
    }

    public static boolean isCompact(int precision) {
        return precision <= 3;
    }
}

