/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

public enum SchemaVersion {
    V_0_1(0, 1);

    public final int majorVersion;
    public final int minorVersion;

    private SchemaVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public static SchemaVersion forValues(int majorVersion, int minorVersion) {
        for (SchemaVersion schemaVersion : SchemaVersion.values()) {
            if (schemaVersion.majorVersion != majorVersion || schemaVersion.minorVersion != minorVersion) continue;
            return schemaVersion;
        }
        throw new IllegalArgumentException(String.format("No schema version found for major version %d and minor version %d", majorVersion, minorVersion));
    }
}

