/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.kadmin.remote;

import java.io.File;
import java.util.List;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminConfig;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminOption;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminSetting;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.AdminUtil;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.RemoteKadminImpl;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.impl.DefaultInternalAdminClient;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.impl.InternalAdminClient;

public class AdminClient {
    private final AdminConfig adminConfig;
    private final KOptions commonOptions;
    private final AdminSetting adminSetting;
    private InternalAdminClient innerClient;

    public AdminClient() throws KrbException {
        this.adminConfig = AdminUtil.getDefaultConfig();
        this.commonOptions = new KOptions();
        this.adminSetting = new AdminSetting(this.commonOptions, this.adminConfig);
    }

    public AdminClient(AdminConfig adminConfig) {
        this.adminConfig = adminConfig;
        this.commonOptions = new KOptions();
        this.adminSetting = new AdminSetting(this.commonOptions, adminConfig);
    }

    public AdminClient(File confDir) throws KrbException {
        this.commonOptions = new KOptions();
        this.adminConfig = AdminUtil.getConfig(confDir);
        this.adminSetting = new AdminSetting(this.commonOptions, this.adminConfig);
    }

    public AdminClient(AdminClient krbClient) {
        this.commonOptions = krbClient.commonOptions;
        this.adminConfig = krbClient.adminConfig;
        this.adminSetting = krbClient.adminSetting;
        this.innerClient = krbClient.innerClient;
    }

    public void setAdminRealm(String realm) {
        this.commonOptions.add((KOption)AdminOption.ADMIN_REALM, (Object)realm);
    }

    public void setKeyTabFile(File file) {
        this.commonOptions.add((KOption)AdminOption.KEYTAB_FILE, (Object)file);
    }

    public void setKdcHost(String kdcHost) {
        this.commonOptions.add((KOption)AdminOption.ADMIN_HOST, (Object)kdcHost);
    }

    public void setAdminTcpPort(int kdcTcpPort) {
        if (kdcTcpPort < 1) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.commonOptions.add((KOption)AdminOption.ADMIN_TCP_PORT, (Object)kdcTcpPort);
        this.setAllowTcp(true);
    }

    public void setAllowUdp(boolean allowUdp) {
        this.commonOptions.add((KOption)AdminOption.ALLOW_UDP, (Object)allowUdp);
    }

    public void setAllowTcp(boolean allowTcp) {
        this.commonOptions.add((KOption)AdminOption.ALLOW_TCP, (Object)allowTcp);
    }

    public void setAdminUdpPort(int adminUdpPort) {
        if (adminUdpPort < 1) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.commonOptions.add((KOption)AdminOption.ADMIN_UDP_PORT, (Object)adminUdpPort);
        this.setAllowUdp(true);
    }

    public void setTimeout(int timeout) {
        this.commonOptions.add((KOption)AdminOption.CONN_TIMEOUT, (Object)timeout);
    }

    public void init() throws KrbException {
        this.innerClient = new DefaultInternalAdminClient(this.adminSetting);
        this.innerClient.init();
    }

    public AdminSetting getSetting() {
        return this.adminSetting;
    }

    public AdminConfig getAdminConfig() {
        return this.adminConfig;
    }

    public void requestAddPrincipal(String principal) throws KrbException {
        RemoteKadminImpl remote = new RemoteKadminImpl(this.innerClient);
        remote.addPrincipal(principal);
    }

    public void requestAddPrincipal(String principal, String password) throws KrbException {
        RemoteKadminImpl remote = new RemoteKadminImpl(this.innerClient);
        remote.addPrincipal(principal, password);
    }

    public void requestDeletePrincipal(String principal) throws KrbException {
        RemoteKadminImpl remote = new RemoteKadminImpl(this.innerClient);
        remote.deletePrincipal(principal);
    }

    public void requestRenamePrincipal(String oldPrincipal, String newPrincipal) throws KrbException {
        RemoteKadminImpl remote = new RemoteKadminImpl(this.innerClient);
        remote.renamePrincipal(oldPrincipal, newPrincipal);
    }

    public List<String> requestGetprincs() throws KrbException {
        RemoteKadminImpl remote = new RemoteKadminImpl(this.innerClient);
        List<String> principalLists = remote.getPrincipals();
        return principalLists;
    }

    public List<String> requestGetprincsWithExp(String exp) throws KrbException {
        RemoteKadminImpl remote = new RemoteKadminImpl(this.innerClient);
        List<String> principalLists = remote.getPrincipals(exp);
        return principalLists;
    }
}

