/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.gravitino.catalog.lakehouse.iceberg.converter.ToIcebergTypeVisitor;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class ToIcebergType
extends ToIcebergTypeVisitor<Type> {
    private final Types.StructType root;
    private int nextId = 0;

    public ToIcebergType() {
        this.root = null;
    }

    public ToIcebergType(Types.StructType root) {
        this.root = root;
        this.nextId = root.fields().length;
    }

    private int getNextId() {
        return this.nextId++;
    }

    @Override
    public Type struct(Types.StructType struct, List<Type> types) {
        Types.StructType.Field[] fields = struct.fields();
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)fields.length);
        boolean isRoot = this.root == struct;
        for (int i = 0; i < fields.length; ++i) {
            Types.StructType.Field field = fields[i];
            Type type = types.get(i);
            int id = isRoot ? i : this.getNextId();
            String doc = field.comment();
            if (field.nullable()) {
                newFields.add(Types.NestedField.optional((int)id, (String)field.name(), (Type)type, (String)doc));
                continue;
            }
            newFields.add(Types.NestedField.required((int)id, (String)field.name(), (Type)type, (String)doc));
        }
        return Types.StructType.of((List)newFields);
    }

    @Override
    public Type field(Types.StructType.Field field, Type typeResult) {
        return typeResult;
    }

    @Override
    public Type array(Types.ListType array, Type elementType) {
        if (array.elementNullable()) {
            return Types.ListType.ofOptional((int)this.getNextId(), (Type)elementType);
        }
        return Types.ListType.ofRequired((int)this.getNextId(), (Type)elementType);
    }

    @Override
    public Type map(Types.MapType map, Type keyType, Type valueType) {
        if (map.valueNullable()) {
            return Types.MapType.ofOptional((int)this.getNextId(), (int)this.getNextId(), (Type)keyType, (Type)valueType);
        }
        return Types.MapType.ofRequired((int)this.getNextId(), (int)this.getNextId(), (Type)keyType, (Type)valueType);
    }

    @Override
    public Type atomic(Type.PrimitiveType primitive) {
        if (primitive instanceof Types.BooleanType) {
            return Types.BooleanType.get();
        }
        if (primitive instanceof Types.ByteType || primitive instanceof Types.ShortType) {
            throw new IllegalArgumentException("Iceberg do not support Byte and Short Type, use Integer instead");
        }
        if (primitive instanceof Types.IntegerType) {
            return Types.IntegerType.get();
        }
        if (primitive instanceof Types.LongType) {
            return Types.LongType.get();
        }
        if (primitive instanceof Types.FloatType) {
            return Types.FloatType.get();
        }
        if (primitive instanceof Types.DoubleType) {
            return Types.DoubleType.get();
        }
        if (primitive instanceof Types.StringType) {
            return Types.StringType.get();
        }
        if (primitive instanceof Types.DateType) {
            return Types.DateType.get();
        }
        if (primitive instanceof Types.TimeType) {
            Types.TimeType timeType = (Types.TimeType)primitive;
            if (!timeType.hasPrecisionSet() || timeType.precision() == 6) {
                return Types.TimeType.get();
            }
            throw new IllegalArgumentException("Iceberg only supports microsecond precision (6) for time type, but got precision: " + timeType.precision());
        }
        if (primitive instanceof Types.TimestampType) {
            Types.TimestampType timestampType = (Types.TimestampType)primitive;
            if (!timestampType.hasPrecisionSet() || timestampType.precision() == 6) {
                if (timestampType.hasTimeZone()) {
                    return Types.TimestampType.withZone();
                }
                return Types.TimestampType.withoutZone();
            }
            String timestampTypeName = timestampType.hasTimeZone() ? "timestamptz" : "timestamp";
            throw new IllegalArgumentException("Iceberg only supports microsecond precision (6) for " + timestampTypeName + " type, but got precision: " + timestampType.precision());
        }
        if (primitive instanceof Types.DecimalType) {
            return Types.DecimalType.of((int)((Types.DecimalType)primitive).precision(), (int)((Types.DecimalType)primitive).scale());
        }
        if (primitive instanceof Types.FixedType) {
            return Types.FixedType.ofLength((int)((Types.FixedType)primitive).length());
        }
        if (primitive instanceof Types.BinaryType) {
            return Types.BinaryType.get();
        }
        if (primitive instanceof Types.UUIDType) {
            return Types.UUIDType.get();
        }
        throw new UnsupportedOperationException("Not a supported type: " + primitive.toString());
    }
}

