/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Locale;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SnapshotRefType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.JsonUtil;

public class SnapshotRefParser {
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String TYPE = "type";
    private static final String MIN_SNAPSHOTS_TO_KEEP = "min-snapshots-to-keep";
    private static final String MAX_SNAPSHOT_AGE_MS = "max-snapshot-age-ms";
    private static final String MAX_REF_AGE_MS = "max-ref-age-ms";

    private SnapshotRefParser() {
    }

    public static String toJson(SnapshotRef ref) {
        return SnapshotRefParser.toJson(ref, false);
    }

    public static String toJson(SnapshotRef ref, boolean pretty) {
        return JsonUtil.generate(gen -> SnapshotRefParser.toJson(ref, gen), pretty);
    }

    public static void toJson(SnapshotRef ref, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField(SNAPSHOT_ID, ref.snapshotId());
        generator.writeStringField(TYPE, ref.type().name().toLowerCase(Locale.ENGLISH));
        JsonUtil.writeIntegerFieldIf(ref.minSnapshotsToKeep() != null, MIN_SNAPSHOTS_TO_KEEP, ref.minSnapshotsToKeep(), generator);
        JsonUtil.writeLongFieldIf(ref.maxSnapshotAgeMs() != null, MAX_SNAPSHOT_AGE_MS, ref.maxSnapshotAgeMs(), generator);
        JsonUtil.writeLongFieldIf(ref.maxRefAgeMs() != null, MAX_REF_AGE_MS, ref.maxRefAgeMs(), generator);
        generator.writeEndObject();
    }

    public static SnapshotRef fromJson(String json) {
        Preconditions.checkArgument((json != null && !json.isEmpty() ? 1 : 0) != 0, (String)"Cannot parse snapshot ref from invalid JSON: %s", (Object)json);
        return JsonUtil.parse(json, SnapshotRefParser::fromJson);
    }

    public static SnapshotRef fromJson(JsonNode node) {
        Preconditions.checkArgument((boolean)node.isObject(), (String)"Cannot parse snapshot reference from a non-object: %s", (Object)node);
        long snapshotId = JsonUtil.getLong(SNAPSHOT_ID, node);
        SnapshotRefType type = SnapshotRefType.fromString((String)JsonUtil.getString(TYPE, node));
        Integer minSnapshotsToKeep = JsonUtil.getIntOrNull(MIN_SNAPSHOTS_TO_KEEP, node);
        Long maxSnapshotAgeMs = JsonUtil.getLongOrNull(MAX_SNAPSHOT_AGE_MS, node);
        Long maxRefAgeMs = JsonUtil.getLongOrNull(MAX_REF_AGE_MS, node);
        return SnapshotRef.builderFor((long)snapshotId, (SnapshotRefType)type).minSnapshotsToKeep(minSnapshotsToKeep).maxSnapshotAgeMs(maxSnapshotAgeMs).maxRefAgeMs(maxRefAgeMs).build();
    }
}

