/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.auth.KerberosUtils;
import org.apache.gravitino.client.AuthDataProvider;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class KerberosTokenProvider
implements AuthDataProvider {
    private final GSSManager gssManager = GSSManager.getInstance();
    private String clientPrincipal;
    private String keytabFile;
    private String host = "localhost";
    private LoginContext loginContext;

    private KerberosTokenProvider() {
    }

    @Override
    public boolean hasTokenData() {
        return true;
    }

    @Override
    public byte[] getTokenData() {
        try {
            return this.getTokenInternal();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get the Kerberos token", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getTokenInternal() throws Exception {
        List<String> principalComponents = Splitter.on('@').splitToList(this.clientPrincipal);
        final String serverPrincipal = "HTTP/" + this.host + "@" + principalComponents.get(1);
        KerberosTokenProvider kerberosTokenProvider = this;
        synchronized (kerberosTokenProvider) {
            if (this.loginContext == null) {
                this.loginContext = KerberosUtils.login(this.clientPrincipal, this.keytabFile);
            } else if (this.isLoginTicketExpired() && this.keytabFile != null) {
                this.loginContext.logout();
                this.loginContext = KerberosUtils.login(this.clientPrincipal, this.keytabFile);
            }
        }
        return KerberosUtils.doAs(this.loginContext.getSubject(), new Callable<byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] call() throws Exception {
                GSSContext gssContext = null;
                try {
                    Oid oid = KerberosUtils.NT_GSS_KRB5_PRINCIPAL_OID;
                    GSSName serviceName = KerberosTokenProvider.this.gssManager.createName(serverPrincipal, oid);
                    oid = KerberosUtils.GSS_KRB5_MECH_OID;
                    gssContext = KerberosTokenProvider.this.gssManager.createContext(serviceName, oid, null, 0);
                    gssContext.requestCredDeleg(true);
                    gssContext.requestMutualAuth(true);
                    byte[] inToken = new byte[]{};
                    byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
                    byte[] byArray = ("Negotiate " + Base64.getEncoder().encodeToString(outToken)).getBytes(StandardCharsets.UTF_8);
                    return byArray;
                }
                finally {
                    if (gssContext != null) {
                        gssContext.dispose();
                    }
                }
            }
        });
    }

    private boolean isLoginTicketExpired() {
        Set<KerberosTicket> tickets = this.loginContext.getSubject().getPrivateCredentials(KerberosTicket.class);
        if (tickets.isEmpty()) {
            return false;
        }
        return tickets.iterator().next().getEndTime().getTime() < System.currentTimeMillis();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.loginContext != null) {
                this.loginContext.logout();
            }
        }
        catch (LoginException le) {
            throw new IOException("Fail to close login context", le);
        }
    }

    void setHost(String host) {
        this.host = host;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String clientPrincipal;
        private File keyTabFile;

        public Builder withClientPrincipal(String clientPrincipal) {
            this.clientPrincipal = clientPrincipal;
            return this;
        }

        public Builder withKeyTabFile(File file) {
            this.keyTabFile = file;
            return this;
        }

        public KerberosTokenProvider build() {
            KerberosTokenProvider provider = new KerberosTokenProvider();
            Preconditions.checkArgument(StringUtils.isNotBlank(this.clientPrincipal), "KerberosTokenProvider must set clientPrincipal");
            Preconditions.checkArgument(Splitter.on('@').splitToList(this.clientPrincipal).size() == 2, "Principal has the wrong format");
            provider.clientPrincipal = this.clientPrincipal;
            if (this.keyTabFile != null) {
                Preconditions.checkArgument(this.keyTabFile.exists(), "KerberosTokenProvider's keytabFile doesn't exist");
                Preconditions.checkArgument(this.keyTabFile.canRead(), "KerberosTokenProvider's keytabFile can't read");
                provider.keytabFile = this.keyTabFile.getAbsolutePath();
            }
            return provider;
        }
    }
}

