/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.outputs;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.Schema;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.outputs.BaseOutputFormat;
import org.apache.gravitino.cli.outputs.LineUtil;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.tag.Tag;

public abstract class PlainFormat<T>
extends BaseOutputFormat<T> {
    public static void output(Object entity, CommandContext context) {
        if (entity instanceof Metalake) {
            new MetalakePlainFormat(context).output((Metalake)entity);
        } else if (entity instanceof Metalake[]) {
            new MetalakeListPlainFormat(context).output((Metalake[])entity);
        } else if (entity instanceof Catalog) {
            new CatalogPlainFormat(context).output((Catalog)entity);
        } else if (entity instanceof Catalog[]) {
            new CatalogListPlainFormat(context).output((Catalog[])entity);
        } else if (entity instanceof Schema) {
            new SchemaPlainFormat(context).output((Schema)entity);
        } else if (entity instanceof Schema[]) {
            new SchemaListPlainFormat(context).output((Schema[])entity);
        } else if (entity instanceof Table) {
            new TablePlainFormat(context).output((Table)entity);
        } else if (entity instanceof Table[]) {
            new TableListPlainFormat(context).output((Table[])entity);
        } else if (entity instanceof Model) {
            new ModelDetailPlainFormat(context).output((Model)entity);
        } else if (entity instanceof Model[]) {
            new ModelListPlainFormat(context).output((Model[])entity);
        } else if (entity instanceof User) {
            new UserDetailsPlainFormat(context).output((User)entity);
        } else if (entity instanceof User[]) {
            new UserListPlainFormat(context).output((User[])entity);
        } else if (entity instanceof Group) {
            new GroupDetailsPlainFormat(context).output((Group)entity);
        } else if (entity instanceof Group[]) {
            new GroupListPlainFormat(context).output((Group[])entity);
        } else if (entity instanceof Audit) {
            new AuditPlainFormat(context).output((Audit)entity);
        } else if (entity instanceof Column[]) {
            new ColumnListPlainFormat(context).output((Column[])entity);
        } else if (entity instanceof Role) {
            new RoleDetailsPlainFormat(context).output((Role)entity);
        } else if (entity instanceof Role[]) {
            new RoleListPlainFormat(context).output((Role[])entity);
        } else if (entity instanceof Fileset) {
            new FilesetDetailsPlainFormat(context).output((Fileset)entity);
        } else if (entity instanceof Fileset[]) {
            new FilesetListPlainFormat(context).output((Fileset[])entity);
        } else if (entity instanceof Topic) {
            new TopicDetailsPlainFormat(context).output((Topic)entity);
        } else if (entity instanceof Topic[]) {
            new TopicListPlainFormat(context).output((Topic[])entity);
        } else if (entity instanceof Tag) {
            new TagDetailsPlainFormat(context).output((Tag)entity);
        } else if (entity instanceof Tag[]) {
            new TagListPlainFormat(context).output((Tag[])entity);
        } else if (entity instanceof Map) {
            new PropertiesListPlainFormat(context).output((Map)entity);
        } else {
            throw new IllegalArgumentException("Unsupported object type: " + (entity == null ? "null" : entity.getClass().getName()));
        }
    }

    protected PlainFormat(CommandContext context) {
        super(context);
    }

    static final class MetalakePlainFormat
    extends PlainFormat<Metalake> {
        public MetalakePlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Metalake metalake) {
            return COMMA_JOINER.join(metalake.name(), metalake.comment(), new Object[0]);
        }
    }

    static final class MetalakeListPlainFormat
    extends PlainFormat<Metalake[]> {
        public MetalakeListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Metalake[] metalakes) {
            List metalakeNames = Arrays.stream(metalakes).map(Metalake::name).collect(Collectors.toList());
            return NEWLINE_JOINER.join(metalakeNames);
        }
    }

    static final class CatalogPlainFormat
    extends PlainFormat<Catalog> {
        public CatalogPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Catalog catalog) {
            return COMMA_JOINER.join(catalog.name(), (Object)catalog.type(), catalog.provider(), catalog.comment());
        }
    }

    static final class CatalogListPlainFormat
    extends PlainFormat<Catalog[]> {
        public CatalogListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Catalog[] catalogs) {
            List catalogNames = Arrays.stream(catalogs).map(Catalog::name).collect(Collectors.toList());
            return NEWLINE_JOINER.join(catalogNames);
        }
    }

    static final class SchemaPlainFormat
    extends PlainFormat<Schema> {
        public SchemaPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Schema schema) {
            return COMMA_JOINER.join(schema.name(), schema.comment(), new Object[0]);
        }
    }

    static final class SchemaListPlainFormat
    extends PlainFormat<Schema[]> {
        public SchemaListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Schema[] schemas) {
            List schemaNames = Arrays.stream(schemas).map(Schema::name).collect(Collectors.toList());
            return NEWLINE_JOINER.join(schemaNames);
        }
    }

    static final class TablePlainFormat
    extends PlainFormat<Table> {
        public TablePlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Table table) {
            String comment = table.comment() == null ? "N/A" : table.comment();
            return COMMA_JOINER.join(new String[]{table.name(), comment});
        }
    }

    static final class TableListPlainFormat
    extends PlainFormat<Table[]> {
        public TableListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Table[] tables) {
            List tableNames = Arrays.stream(tables).map(Table::name).collect(Collectors.toList());
            return NEWLINE_JOINER.join(tableNames);
        }
    }

    static final class ModelDetailPlainFormat
    extends PlainFormat<Model> {
        public ModelDetailPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Model model) {
            return String.format("Model name %s, latest version: %s%n", model.name(), model.latestVersion());
        }
    }

    static final class ModelListPlainFormat
    extends PlainFormat<Model[]> {
        public ModelListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Model[] models) {
            return COMMA_JOINER.join(Arrays.stream(models).map(Model::name).collect(Collectors.toList()));
        }
    }

    static final class UserDetailsPlainFormat
    extends PlainFormat<User> {
        public UserDetailsPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(User user) {
            return COMMA_JOINER.join(user.roles());
        }
    }

    static final class UserListPlainFormat
    extends PlainFormat<User[]> {
        public UserListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(User[] users) {
            return COMMA_JOINER.join(Arrays.stream(users).map(User::name).collect(Collectors.toList()));
        }
    }

    static final class GroupDetailsPlainFormat
    extends PlainFormat<Group> {
        public GroupDetailsPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Group group) {
            return COMMA_JOINER.join(group.roles());
        }
    }

    static final class GroupListPlainFormat
    extends PlainFormat<Group[]> {
        public GroupListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Group[] groups) {
            return COMMA_JOINER.join(Arrays.stream(groups).map(Group::name).collect(Collectors.toList()));
        }
    }

    static final class AuditPlainFormat
    extends PlainFormat<Audit> {
        public AuditPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Audit audit) {
            return COMMA_JOINER.join(audit.creator(), audit.createTime() == null ? "N/A" : audit.createTime(), audit.lastModifier() == null ? "N/A" : audit.lastModifier(), audit.lastModifiedTime() == null ? "N/A" : audit.lastModifiedTime());
        }
    }

    static final class ColumnListPlainFormat
    extends PlainFormat<Column[]> {
        public ColumnListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Column[] columns) {
            String header = COMMA_JOINER.join("name", "datatype", "default_value", "comment", "nullable", "auto_increment");
            StringBuilder data = new StringBuilder();
            for (int i = 0; i < columns.length; ++i) {
                String name = columns[i].name();
                String dataType = columns[i].dataType().simpleString();
                String defaultValue = LineUtil.getDefaultValue(columns[i]);
                String comment = LineUtil.getComment(columns[i]);
                String nullable = columns[i].nullable() ? "true" : "false";
                String autoIncrement = LineUtil.getAutoIncrement(columns[i]);
                data.append(COMMA_JOINER.join(name, dataType, defaultValue, comment, nullable, autoIncrement));
                data.append(System.lineSeparator());
            }
            return NEWLINE_JOINER.join(header, data.toString(), new Object[0]);
        }
    }

    static final class RoleDetailsPlainFormat
    extends PlainFormat<Role> {
        public RoleDetailsPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Role entity) {
            List<SecurableObject> objects = entity.securableObjects();
            StringBuilder sb = new StringBuilder();
            for (SecurableObject object : objects) {
                sb.append(object.name()).append(",").append((Object)object.type()).append(",").append("\n");
                sb.append(String.join((CharSequence)"\n", (CharSequence[])object.privileges().stream().map(Privilege::simpleString).toArray(String[]::new)));
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    static final class RoleListPlainFormat
    extends PlainFormat<Role[]> {
        public RoleListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Role[] entity) {
            List roleList = Arrays.stream(entity).map(Role::name).collect(Collectors.toList());
            return String.join((CharSequence)",", roleList);
        }
    }

    static final class FilesetDetailsPlainFormat
    extends PlainFormat<Fileset> {
        public FilesetDetailsPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Fileset entity) {
            String filesetType = entity.type() == Fileset.Type.MANAGED ? "managed" : "external";
            return entity.name() + "," + filesetType + "," + entity.comment() + "," + entity.storageLocation();
        }
    }

    static final class FilesetListPlainFormat
    extends PlainFormat<Fileset[]> {
        public FilesetListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Fileset[] entity) {
            List filesetList = Arrays.stream(entity).map(Fileset::name).collect(Collectors.toList());
            return String.join((CharSequence)",", filesetList);
        }
    }

    static final class TopicDetailsPlainFormat
    extends PlainFormat<Topic> {
        public TopicDetailsPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Topic entity) {
            return entity.name() + "," + entity.comment();
        }
    }

    static final class TopicListPlainFormat
    extends PlainFormat<Topic[]> {
        public TopicListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Topic[] entity) {
            List topicList = Arrays.stream(entity).map(Topic::name).collect(Collectors.toList());
            return String.join((CharSequence)",", topicList);
        }
    }

    static final class TagDetailsPlainFormat
    extends PlainFormat<Tag> {
        public TagDetailsPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Tag tag) {
            String comment = tag.comment() == null ? "N/A" : tag.comment();
            return COMMA_JOINER.join(tag.name(), comment, new Object[0]);
        }
    }

    static final class TagListPlainFormat
    extends PlainFormat<Tag[]> {
        public TagListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Tag[] tags) {
            List tagNames = Arrays.stream(tags).map(Tag::name).collect(Collectors.toList());
            return NEWLINE_JOINER.join(tagNames);
        }
    }

    static final class PropertiesListPlainFormat
    extends PlainFormat<Map<?, ?>> {
        public PropertiesListPlainFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Map<?, ?> properties) {
            StringBuilder data = new StringBuilder();
            properties.forEach((key, value) -> {
                data.append(COMMA_JOINER.join(key.toString(), value.toString(), new Object[0]));
                data.append(System.lineSeparator());
            });
            return data.toString();
        }
    }
}

