/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cache;

import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.cache.ReverseIndexCache;
import org.apache.gravitino.meta.GroupEntity;
import org.apache.gravitino.meta.RoleEntity;
import org.apache.gravitino.meta.UserEntity;
import org.apache.gravitino.utils.NamespaceUtil;

public class ReverseIndexRules {
    public static final ReverseIndexCache.ReverseIndexRule USER_REVERSE_RULE = (entity, key, reverseIndexCache) -> {
        UserEntity userEntity = (UserEntity)entity;
        if (userEntity.roleNames() != null) {
            userEntity.roleNames().forEach(role -> {
                Namespace ns = NamespaceUtil.ofRole(userEntity.namespace().level(0));
                NameIdentifier nameIdentifier = NameIdentifier.of((Namespace)ns, (String)role);
                reverseIndexCache.put(nameIdentifier, Entity.EntityType.ROLE, key);
            });
        }
    };
    public static final ReverseIndexCache.ReverseIndexRule GROUP_REVERSE_RULE = (entity, key, reverseIndexCache) -> {
        GroupEntity groupEntity = (GroupEntity)entity;
        if (groupEntity.roleNames() != null) {
            groupEntity.roleNames().forEach(role -> {
                Namespace ns = NamespaceUtil.ofRole(groupEntity.namespace().level(0));
                NameIdentifier nameIdentifier = NameIdentifier.of((Namespace)ns, (String)role);
                reverseIndexCache.put(nameIdentifier, Entity.EntityType.ROLE, key);
            });
        }
    };
    public static final ReverseIndexCache.ReverseIndexRule ROLE_REVERSE_RULE = (entity, key, reverseIndexCache) -> {
        RoleEntity roleEntity = (RoleEntity)entity;
        if (roleEntity.securableObjects() != null) {
            roleEntity.securableObjects().forEach(securableObject -> {
                Namespace namespace = Namespace.empty();
                Entity.EntityType entityType = Entity.EntityType.METALAKE;
                switch (securableObject.type()) {
                    case METALAKE: {
                        entityType = Entity.EntityType.METALAKE;
                        namespace = NamespaceUtil.ofMetalake();
                        break;
                    }
                    case CATALOG: {
                        entityType = Entity.EntityType.CATALOG;
                        namespace = NamespaceUtil.ofCatalog(roleEntity.namespace().level(0));
                        break;
                    }
                    case SCHEMA: {
                        entityType = Entity.EntityType.SCHEMA;
                        Namespace nsSchema = Namespace.fromString((String)securableObject.parent());
                        namespace = NamespaceUtil.ofSchema(roleEntity.namespace().level(0), nsSchema.level(0));
                        break;
                    }
                    case TABLE: {
                        entityType = Entity.EntityType.TABLE;
                        Namespace nsTable = Namespace.fromString((String)securableObject.parent());
                        namespace = NamespaceUtil.ofTable(roleEntity.namespace().level(0), nsTable.level(0), nsTable.level(1));
                        break;
                    }
                    case TOPIC: {
                        entityType = Entity.EntityType.TOPIC;
                        Namespace nsTopic = Namespace.fromString((String)securableObject.parent());
                        namespace = NamespaceUtil.ofTopic(roleEntity.namespace().level(0), nsTopic.level(0), nsTopic.level(1));
                        break;
                    }
                    case MODEL: {
                        entityType = Entity.EntityType.MODEL;
                        Namespace nsModel = Namespace.fromString((String)securableObject.parent());
                        namespace = NamespaceUtil.ofModel(roleEntity.namespace().level(0), nsModel.level(0), nsModel.level(1));
                        break;
                    }
                    case FILESET: {
                        entityType = Entity.EntityType.FILESET;
                        Namespace nsFileset = Namespace.fromString((String)securableObject.parent());
                        namespace = NamespaceUtil.ofFileset(roleEntity.namespace().level(0), nsFileset.level(0), nsFileset.level(1));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Don't support securable object type: " + String.valueOf(securableObject.type()));
                    }
                }
                Namespace securableObjectNamespace = Namespace.of((String[])namespace.levels());
                NameIdentifier securableObjectIdent = NameIdentifier.of((Namespace)securableObjectNamespace, (String)securableObject.name());
                reverseIndexCache.put(securableObjectIdent, entityType, key);
            });
        }
    };
}

