/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import java.util.List;
import org.apache.gravitino.storage.relational.mapper.provider.base.UserRoleRelBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.UserRoleRelPO;
import org.apache.ibatis.annotations.Param;

public class UserRoleRelPostgreSQLProvider
extends UserRoleRelBaseSQLProvider {
    @Override
    public String softDeleteUserRoleRelByUserId(Long userId) {
        return "UPDATE user_role_rel SET deleted_at = floor(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00'))*1000) WHERE user_id = #{userId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteUserRoleRelByUserAndRoles(Long userId, List<Long> roleIds) {
        return "<script>UPDATE user_role_rel SET deleted_at = floor(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00'))*1000) WHERE user_id = #{userId} AND role_id in (<foreach collection='roleIds' item='roleId' separator=','>#{roleId}</foreach>) AND deleted_at = 0</script>";
    }

    @Override
    public String softDeleteUserRoleRelByMetalakeId(Long metalakeId) {
        return "UPDATE user_role_rel SET deleted_at = floor(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00'))*1000) WHERE user_id IN (SELECT user_id FROM user_meta WHERE metalake_id = #{metalakeId} AND deleted_at = 0) AND deleted_at = 0";
    }

    @Override
    public String softDeleteUserRoleRelByRoleId(Long roleId) {
        return "UPDATE user_role_rel SET deleted_at = floor(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00'))*1000) WHERE role_id = #{roleId} AND deleted_at = 0";
    }

    @Override
    public String batchInsertUserRoleRelOnDuplicateKeyUpdate(List<UserRoleRelPO> userRoleRelPOs) {
        return "<script>INSERT INTO user_role_rel(user_id, role_id, audit_info, current_version, last_version, deleted_at) VALUES <foreach collection='userRoleRels' item='item' separator=','>(#{item.userId}, #{item.roleId}, #{item.auditInfo}, #{item.currentVersion}, #{item.lastVersion}, #{item.deletedAt})</foreach> ON CONFLICT (user_id, role_id, deleted_at) DO UPDATE SET user_id = EXCLUDED.user_id, role_id = EXCLUDED.role_id, audit_info = EXCLUDED.audit_info, current_version = EXCLUDED.current_version, last_version = EXCLUDED.last_version, deleted_at = EXCLUDED.deleted_at</script>";
    }

    @Override
    public String deleteUserRoleRelMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM user_role_rel WHERE id IN (SELECT id FROM user_role_rel WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }
}

