/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.localmerge;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.DataSetters;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.BinaryRowSerializer;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.hash.BytesHashMap;
import org.apache.paimon.hash.BytesMap;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.localmerge.LocalMerger;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FieldsComparator;
import org.apache.paimon.utils.KeyValueIterator;

public class HashMapLocalMerger
implements LocalMerger {
    private final InternalRowSerializer valueSerializer;
    private final MergeFunction<KeyValue> mergeFunction;
    @Nullable
    private final FieldsComparator udsComparator;
    private final BytesHashMap<BinaryRow> buffer;
    private final List<InternalRow.FieldSetter> nonKeySetters;

    public HashMapLocalMerger(RowType rowType, List<String> primaryKeys, MemorySegmentPool memoryPool, MergeFunction<KeyValue> mergeFunction, @Nullable FieldsComparator userDefinedSeqComparator) {
        this.valueSerializer = new InternalRowSerializer(rowType);
        this.mergeFunction = mergeFunction;
        this.udsComparator = userDefinedSeqComparator;
        this.buffer = new BytesHashMap(memoryPool, new BinaryRowSerializer(primaryKeys.size()), rowType.getFieldCount());
        this.nonKeySetters = new ArrayList<InternalRow.FieldSetter>();
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            DataField field = (DataField)rowType.getFields().get(i);
            if (primaryKeys.contains(field.name())) continue;
            this.nonKeySetters.add(InternalRow.createFieldSetter((DataType)field.type(), (int)i));
        }
    }

    @Override
    public boolean put(RowKind rowKind, BinaryRow key, InternalRow value) throws IOException {
        value.setRowKind(rowKind);
        BytesMap.LookupInfo lookup = this.buffer.lookup(key);
        if (!lookup.isFound()) {
            try {
                this.buffer.append(lookup, this.valueSerializer.toBinaryRow(value));
                return true;
            }
            catch (EOFException eof) {
                return false;
            }
        }
        this.mergeFunction.reset();
        BinaryRow stored = (BinaryRow)lookup.getValue();
        KeyValue previousKv = new KeyValue().replace((InternalRow)key, stored.getRowKind(), (InternalRow)stored);
        KeyValue newKv = new KeyValue().replace((InternalRow)key, value.getRowKind(), value);
        if (this.udsComparator != null && this.udsComparator.compare((Object)stored, (Object)value) > 0) {
            this.mergeFunction.add(newKv);
            this.mergeFunction.add(previousKv);
        } else {
            this.mergeFunction.add(previousKv);
            this.mergeFunction.add(newKv);
        }
        KeyValue result = this.mergeFunction.getResult();
        stored.setRowKind(result.valueKind());
        for (InternalRow.FieldSetter setter : this.nonKeySetters) {
            setter.setFieldFrom((DataGetters)result.value(), (DataSetters)stored);
        }
        return true;
    }

    @Override
    public int size() {
        return this.buffer.getNumElements();
    }

    @Override
    public void forEach(Consumer<InternalRow> consumer) throws IOException {
        KeyValueIterator<BinaryRow, BinaryRow> iterator = this.buffer.getEntryIterator(false);
        while (iterator.advanceNext()) {
            consumer.accept((InternalRow)iterator.getValue());
        }
    }

    @Override
    public void clear() {
        this.buffer.reset();
    }
}

