/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.hudi.backend.hms.kerberos;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.catalog.lakehouse.hudi.backend.hms.kerberos.AuthenticationConfig;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;

public class KerberosConfig
extends AuthenticationConfig {
    public static final String KEY_TAB_URI_KEY = "authentication.kerberos.keytab-uri";
    public static final String PRINCIPAL_KEY = "authentication.kerberos.principal";
    public static final String CHECK_INTERVAL_SEC_KEY = "authentication.kerberos.check-interval-sec";
    public static final String FETCH_TIMEOUT_SEC_KEY = "authentication.kerberos.keytab-fetch-timeout-sec";
    public static final ConfigEntry<String> PRINCIPAL_ENTRY = new ConfigBuilder("authentication.kerberos.principal").doc("The principal of the Kerberos connection").version("1.0.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<String> KEYTAB_ENTRY = new ConfigBuilder("authentication.kerberos.keytab-uri").doc("The keytab of the Kerberos connection").version("1.0.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").create();
    public static final ConfigEntry<Integer> CHECK_INTERVAL_SEC_ENTRY = new ConfigBuilder("authentication.kerberos.check-interval-sec").doc("The check interval of the Kerberos connection for Hudi catalog").version("1.0.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)60);
    public static final ConfigEntry<Integer> FETCH_TIMEOUT_SEC_ENTRY = new ConfigBuilder("authentication.kerberos.keytab-fetch-timeout-sec").doc("The fetch timeout of the Kerberos connection").version("1.0.0").intConf().checkValue(value -> value > 0, "The value must be a positive number").createWithDefault((Object)60);

    public KerberosConfig(Map<String, String> properties) {
        super(properties);
        this.loadFromMap(properties, k -> true);
    }

    public String getPrincipalName() {
        return (String)this.get(PRINCIPAL_ENTRY);
    }

    public String getKeytab() {
        return (String)this.get(KEYTAB_ENTRY);
    }

    public int getCheckIntervalSec() {
        return (Integer)this.get(CHECK_INTERVAL_SEC_ENTRY);
    }

    public int getFetchTimeoutSec() {
        return (Integer)this.get(FETCH_TIMEOUT_SEC_ENTRY);
    }
}

