/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.NoopBackgroundEvent;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.NoopApplicationEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public class DefaultBackgroundThread
extends KafkaThread {
    private static final String BACKGROUND_THREAD_NAME = "consumer_background_thread";
    private final Time time;
    private final Logger log;
    private final BlockingQueue<ApplicationEvent> applicationEventQueue;
    private final BlockingQueue<BackgroundEvent> backgroundEventQueue;
    private final ConsumerNetworkClient networkClient;
    private final SubscriptionState subscriptions;
    private final ConsumerMetadata metadata;
    private final Metrics metrics;
    private final ConsumerConfig config;
    private String clientId;
    private long retryBackoffMs;
    private int heartbeatIntervalMs;
    private boolean running;
    private Optional<ApplicationEvent> inflightEvent = Optional.empty();
    private final AtomicReference<Optional<RuntimeException>> exception = new AtomicReference(Optional.empty());

    public DefaultBackgroundThread(Time time, ConsumerConfig config, LogContext logContext, BlockingQueue<ApplicationEvent> applicationEventQueue, BlockingQueue<BackgroundEvent> backgroundEventQueue, SubscriptionState subscriptions, ConsumerMetadata metadata, ConsumerNetworkClient networkClient, Metrics metrics) {
        super(BACKGROUND_THREAD_NAME, true);
        try {
            this.time = time;
            this.log = logContext.logger(DefaultBackgroundThread.class);
            this.applicationEventQueue = applicationEventQueue;
            this.backgroundEventQueue = backgroundEventQueue;
            this.config = config;
            this.setConfig();
            this.inflightEvent = Optional.empty();
            this.subscriptions = subscriptions;
            this.metadata = metadata;
            this.networkClient = networkClient;
            this.metrics = metrics;
            this.running = true;
        }
        catch (Exception e) {
            this.close();
            throw new KafkaException("Failed to construct background processor", e);
        }
    }

    private void setConfig() {
        this.retryBackoffMs = this.config.getLong("retry.backoff.ms");
        this.clientId = this.config.getString("client.id");
        this.heartbeatIntervalMs = this.config.getInt("heartbeat.interval.ms");
    }

    @Override
    public void run() {
        try {
            this.log.debug("Background thread started");
            while (this.running) {
                try {
                    this.runOnce();
                }
                catch (WakeupException e) {
                    this.log.debug("Exception thrown, background thread won't terminate", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            this.log.error("The background thread failed due to unexpected error", t);
            if (t instanceof RuntimeException) {
                this.exception.set(Optional.of((RuntimeException)t));
            } else {
                this.exception.set(Optional.of(new RuntimeException(t)));
            }
        }
        finally {
            this.close();
            this.log.debug("{} closed", this.getClass());
        }
    }

    void runOnce() {
        this.inflightEvent = this.maybePollEvent();
        if (this.inflightEvent.isPresent()) {
            this.log.debug("processing application event: {}", this.inflightEvent);
        }
        if (this.inflightEvent.isPresent() && this.maybeConsumeInflightEvent(this.inflightEvent.get())) {
            this.inflightEvent = Optional.empty();
        }
        if (!this.applicationEventQueue.isEmpty() || this.inflightEvent.isPresent()) {
            this.networkClient.poll(this.time.timer(0L));
            return;
        }
        this.networkClient.poll(this.time.timer(this.timeToNextHeartbeatMs(this.time.milliseconds())));
    }

    private long timeToNextHeartbeatMs(long nowMs) {
        return 100L;
    }

    private Optional<ApplicationEvent> maybePollEvent() {
        if (this.inflightEvent.isPresent() || this.applicationEventQueue.isEmpty()) {
            return this.inflightEvent;
        }
        return Optional.ofNullable(this.applicationEventQueue.poll());
    }

    private boolean maybeConsumeInflightEvent(ApplicationEvent event) {
        this.log.debug("try consuming event: {}", Optional.ofNullable(event));
        Objects.requireNonNull(event);
        return event.process();
    }

    private void process(NoopApplicationEvent event) {
        this.backgroundEventQueue.add(new NoopBackgroundEvent(event.message));
    }

    public boolean isRunning() {
        return this.running;
    }

    public void wakeup() {
        this.networkClient.wakeup();
    }

    public void close() {
        this.running = false;
        this.wakeup();
        Utils.closeQuietly(this.networkClient, "consumer network client");
        Utils.closeQuietly(this.metadata, "consumer metadata client");
    }
}

