/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.types.Type;

@Evolving
public interface TableChange {
    public static TableChange rename(String newName) {
        return new RenameTable(newName);
    }

    public static TableChange updateComment(String newComment) {
        return new UpdateComment(newComment);
    }

    public static TableChange setProperty(String property, String value) {
        return new SetProperty(property, value);
    }

    public static TableChange removeProperty(String property) {
        return new RemoveProperty(property);
    }

    public static TableChange addColumn(String[] fieldName, Type dataType) {
        return new AddColumn(fieldName, dataType, null, null, true, false, Column.DEFAULT_VALUE_NOT_SET);
    }

    public static TableChange addColumn(String[] fieldName, Type dataType, String comment) {
        return new AddColumn(fieldName, dataType, comment, null, true, false, Column.DEFAULT_VALUE_NOT_SET);
    }

    public static TableChange addColumn(String[] fieldName, Type dataType, ColumnPosition position) {
        return new AddColumn(fieldName, dataType, null, position, true, false, Column.DEFAULT_VALUE_NOT_SET);
    }

    public static TableChange addColumn(String[] fieldName, Type dataType, String comment, ColumnPosition position) {
        return new AddColumn(fieldName, dataType, comment, position, true, false, Column.DEFAULT_VALUE_NOT_SET);
    }

    public static TableChange addColumn(String[] fieldName, Type dataType, boolean nullable) {
        return new AddColumn(fieldName, dataType, null, null, nullable, false, Column.DEFAULT_VALUE_NOT_SET);
    }

    public static TableChange addColumn(String[] fieldName, Type dataType, String comment, boolean nullable) {
        return new AddColumn(fieldName, dataType, comment, null, nullable, false, Column.DEFAULT_VALUE_NOT_SET);
    }

    public static TableChange addColumn(String[] fieldName, Type dataType, Expression defaultValue) {
        return new AddColumn(fieldName, dataType, null, null, true, false, defaultValue);
    }

    public static TableChange addColumn(String[] fieldName, Type dataType, String comment, Expression defaultValue) {
        return new AddColumn(fieldName, dataType, comment, null, true, false, defaultValue);
    }

    public static TableChange addColumn(String[] fieldName, Type dataType, ColumnPosition position, Expression defaultValue) {
        return new AddColumn(fieldName, dataType, null, position, true, false, defaultValue);
    }

    public static TableChange addColumn(String[] fieldName, Type dataType, String comment, ColumnPosition position, Expression defaultValue) {
        return new AddColumn(fieldName, dataType, comment, position, true, false, defaultValue);
    }

    public static TableChange addColumn(String[] fieldName, Type dataType, String comment, ColumnPosition position, boolean nullable) {
        return new AddColumn(fieldName, dataType, comment, position, nullable, false, Column.DEFAULT_VALUE_NOT_SET);
    }

    public static TableChange addColumn(String[] fieldName, Type dataType, String comment, ColumnPosition position, boolean nullable, boolean autoIncrement) {
        return new AddColumn(fieldName, dataType, comment, position, nullable, autoIncrement, Column.DEFAULT_VALUE_NOT_SET);
    }

    public static TableChange addColumn(String[] fieldName, Type dataType, String comment, ColumnPosition position, boolean nullable, boolean autoIncrement, Expression defaultValue) {
        return new AddColumn(fieldName, dataType, comment, position, nullable, autoIncrement, defaultValue);
    }

    public static TableChange renameColumn(String[] fieldName, String newName) {
        return new RenameColumn(fieldName, newName);
    }

    public static TableChange updateColumnDefaultValue(String[] fieldName, Expression newDefaultValue) {
        return new UpdateColumnDefaultValue(fieldName, newDefaultValue);
    }

    public static TableChange updateColumnType(String[] fieldName, Type newDataType) {
        return new UpdateColumnType(fieldName, newDataType);
    }

    public static TableChange updateColumnComment(String[] fieldName, String newComment) {
        return new UpdateColumnComment(fieldName, newComment);
    }

    public static TableChange updateColumnPosition(String[] fieldName, ColumnPosition newPosition) {
        return new UpdateColumnPosition(fieldName, newPosition);
    }

    public static TableChange deleteColumn(String[] fieldName, Boolean ifExists) {
        return new DeleteColumn(fieldName, ifExists);
    }

    public static TableChange updateColumnNullability(String[] fieldName, boolean nullable) {
        return new UpdateColumnNullability(fieldName, nullable);
    }

    public static TableChange addIndex(Index.IndexType type, String name, String[][] fieldNames) {
        return new AddIndex(type, name, fieldNames);
    }

    public static TableChange deleteIndex(String name, Boolean ifExists) {
        return new DeleteIndex(name, ifExists);
    }

    public static TableChange updateColumnAutoIncrement(String[] fieldName, boolean autoIncrement) {
        return new UpdateColumnAutoIncrement(fieldName, autoIncrement);
    }

    public static final class RenameTable
    implements TableChange {
        private final String newName;

        private RenameTable(String newName) {
            this.newName = newName;
        }

        public String getNewName() {
            return this.newName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenameTable that = (RenameTable)o;
            return this.newName.equals(that.newName);
        }

        public int hashCode() {
            return this.newName.hashCode();
        }

        public String toString() {
            return "RENAMETABLE " + this.newName;
        }
    }

    public static final class UpdateComment
    implements TableChange {
        private final String newComment;

        private UpdateComment(String newComment) {
            this.newComment = newComment;
        }

        public String getNewComment() {
            return this.newComment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateComment that = (UpdateComment)o;
            return this.newComment.equals(that.newComment);
        }

        public int hashCode() {
            return this.newComment.hashCode();
        }

        public String toString() {
            return "UPDATECOMMENT " + this.newComment;
        }
    }

    public static final class SetProperty
    implements TableChange {
        private final String property;
        private final String value;

        public SetProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        public String getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetProperty that = (SetProperty)o;
            return this.property.equals(that.property) && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.value);
        }

        public String toString() {
            return "SETPROPERTY " + this.property + " " + this.value;
        }
    }

    public static final class RemoveProperty
    implements TableChange {
        private final String property;

        private RemoveProperty(String property) {
            this.property = property;
        }

        public String getProperty() {
            return this.property;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveProperty that = (RemoveProperty)o;
            return this.property.equals(that.property);
        }

        public int hashCode() {
            return Objects.hash(this.property);
        }

        public String toString() {
            return "REMOVEPROPERTY " + this.property;
        }
    }

    public static final class AddColumn
    implements ColumnChange {
        private final String[] fieldName;
        private final Type dataType;
        private final String comment;
        private final ColumnPosition position;
        private final boolean nullable;
        private final boolean autoIncrement;
        private final Expression defaultValue;

        private AddColumn(String[] fieldName, Type dataType, String comment, ColumnPosition position, boolean nullable, boolean autoIncrement, Expression defaultValue) {
            this.fieldName = fieldName;
            this.dataType = dataType;
            this.comment = comment;
            this.position = position == null ? ColumnPosition.defaultPos() : position;
            this.nullable = nullable;
            this.autoIncrement = autoIncrement;
            this.defaultValue = defaultValue;
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public Type getDataType() {
            return this.dataType;
        }

        public String getComment() {
            return this.comment;
        }

        public ColumnPosition getPosition() {
            return this.position;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public Expression getDefaultValue() {
            return this.defaultValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddColumn addColumn = (AddColumn)o;
            return this.nullable == addColumn.nullable && this.autoIncrement == addColumn.autoIncrement && Arrays.equals(this.fieldName, addColumn.fieldName) && Objects.equals(this.dataType, addColumn.dataType) && Objects.equals(this.comment, addColumn.comment) && Objects.equals(this.position, addColumn.position) && Objects.equals(this.defaultValue, addColumn.defaultValue);
        }

        public int hashCode() {
            int result = Objects.hash(this.dataType, this.comment, this.position, this.nullable, this.autoIncrement, this.defaultValue);
            result = 31 * result + Arrays.hashCode(this.fieldName);
            return result;
        }

        @Override
        public String[] fieldName() {
            return this.fieldName;
        }
    }

    public static interface ColumnPosition {
        public static ColumnPosition first() {
            return First.INSTANCE;
        }

        public static ColumnPosition after(String column) {
            return new After(column);
        }

        public static ColumnPosition defaultPos() {
            return Default.INSTANCE;
        }
    }

    public static final class RenameColumn
    implements ColumnChange {
        private final String[] fieldName;
        private final String newName;

        private RenameColumn(String[] fieldName, String newName) {
            this.fieldName = fieldName;
            this.newName = newName;
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public String getNewName() {
            return this.newName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenameColumn that = (RenameColumn)o;
            return Arrays.equals(this.fieldName, that.fieldName) && Objects.equals(this.newName, that.newName);
        }

        public int hashCode() {
            int result = Objects.hash(this.newName);
            result = 31 * result + Arrays.hashCode(this.fieldName);
            return result;
        }

        @Override
        public String[] fieldName() {
            return this.fieldName;
        }
    }

    public static final class UpdateColumnDefaultValue
    implements ColumnChange {
        private final String[] fieldName;
        private final Expression newDefaultValue;

        private UpdateColumnDefaultValue(String[] fieldName, Expression newDefaultValue) {
            this.fieldName = fieldName;
            this.newDefaultValue = newDefaultValue;
        }

        @Override
        public String[] fieldName() {
            return this.fieldName;
        }

        public Expression getNewDefaultValue() {
            return this.newDefaultValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnDefaultValue that = (UpdateColumnDefaultValue)o;
            return Arrays.equals(this.fieldName, that.fieldName) && Objects.equals(this.newDefaultValue, that.newDefaultValue);
        }

        public int hashCode() {
            int result = Objects.hash(this.newDefaultValue);
            result = 31 * result + Arrays.hashCode(this.fieldName);
            return result;
        }
    }

    public static final class UpdateColumnType
    implements ColumnChange {
        private final String[] fieldName;
        private final Type newDataType;

        private UpdateColumnType(String[] fieldName, Type newDataType) {
            this.fieldName = fieldName;
            this.newDataType = newDataType;
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public Type getNewDataType() {
            return this.newDataType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnType that = (UpdateColumnType)o;
            return Arrays.equals(this.fieldName, that.fieldName) && Objects.equals(this.newDataType, that.newDataType);
        }

        public int hashCode() {
            int result = Objects.hash(this.newDataType);
            result = 31 * result + Arrays.hashCode(this.fieldName);
            return result;
        }

        @Override
        public String[] fieldName() {
            return this.fieldName;
        }
    }

    public static final class UpdateColumnComment
    implements ColumnChange {
        private final String[] fieldName;
        private final String newComment;

        private UpdateColumnComment(String[] fieldName, String newComment) {
            this.fieldName = fieldName;
            this.newComment = newComment;
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public String getNewComment() {
            return this.newComment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnComment that = (UpdateColumnComment)o;
            return Arrays.equals(this.fieldName, that.fieldName) && Objects.equals(this.newComment, that.newComment);
        }

        public int hashCode() {
            int result = Objects.hash(this.newComment);
            result = 31 * result + Arrays.hashCode(this.fieldName);
            return result;
        }

        @Override
        public String[] fieldName() {
            return this.fieldName;
        }
    }

    public static final class UpdateColumnPosition
    implements ColumnChange {
        private final String[] fieldName;
        private final ColumnPosition position;

        private UpdateColumnPosition(String[] fieldName, ColumnPosition position) {
            Preconditions.checkArgument((position != ColumnPosition.defaultPos() ? 1 : 0) != 0, (Object)"Position cannot be DEFAULT");
            this.fieldName = fieldName;
            this.position = position;
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public ColumnPosition getPosition() {
            return this.position;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnPosition that = (UpdateColumnPosition)o;
            return Arrays.equals(this.fieldName, that.fieldName) && Objects.equals(this.position, that.position);
        }

        public int hashCode() {
            int result = Objects.hash(this.position);
            result = 31 * result + Arrays.hashCode(this.fieldName);
            return result;
        }

        @Override
        public String[] fieldName() {
            return this.fieldName;
        }
    }

    public static final class DeleteColumn
    implements ColumnChange {
        private final String[] fieldName;
        private final Boolean ifExists;

        private DeleteColumn(String[] fieldName, Boolean ifExists) {
            this.fieldName = fieldName;
            this.ifExists = ifExists;
        }

        public String[] getFieldName() {
            return this.fieldName;
        }

        public Boolean getIfExists() {
            return this.ifExists;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeleteColumn that = (DeleteColumn)o;
            return Arrays.equals(this.fieldName, that.fieldName) && Objects.equals(this.ifExists, that.ifExists);
        }

        public int hashCode() {
            int result = Objects.hash(this.ifExists);
            result = 31 * result + Arrays.hashCode(this.fieldName);
            return result;
        }

        @Override
        public String[] fieldName() {
            return this.fieldName;
        }
    }

    public static final class UpdateColumnNullability
    implements ColumnChange {
        private final String[] fieldName;
        private final boolean nullable;

        private UpdateColumnNullability(String[] fieldName, boolean nullable) {
            this.fieldName = fieldName;
            this.nullable = nullable;
        }

        @Override
        public String[] fieldName() {
            return this.fieldName;
        }

        public boolean nullable() {
            return this.nullable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnNullability that = (UpdateColumnNullability)o;
            return this.nullable == that.nullable && Arrays.equals(this.fieldName, that.fieldName);
        }

        public int hashCode() {
            int result = Objects.hash(this.nullable);
            result = 31 * result + Arrays.hashCode(this.fieldName);
            return result;
        }
    }

    public static final class AddIndex
    implements TableChange {
        private final Index.IndexType type;
        private final String name;
        private final String[][] fieldNames;

        public AddIndex(Index.IndexType type, String name, String[][] fieldNames) {
            this.type = type;
            this.name = name;
            this.fieldNames = fieldNames;
        }

        public Index.IndexType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String[][] getFieldNames() {
            return this.fieldNames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddIndex addIndex = (AddIndex)o;
            return this.type == addIndex.type && Objects.equals(this.name, addIndex.name) && Arrays.deepEquals((Object[])this.fieldNames, (Object[])addIndex.fieldNames);
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.type, this.name});
            result = 31 * result + Arrays.hashCode((Object[])this.fieldNames);
            return result;
        }
    }

    public static final class DeleteIndex
    implements TableChange {
        private final String name;
        private final boolean ifExists;

        public DeleteIndex(String name, boolean ifExists) {
            this.name = name;
            this.ifExists = ifExists;
        }

        public String getName() {
            return this.name;
        }

        public boolean isIfExists() {
            return this.ifExists;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeleteIndex that = (DeleteIndex)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.ifExists, that.ifExists);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.ifExists);
        }
    }

    public static final class UpdateColumnAutoIncrement
    implements ColumnChange {
        private final String[] fieldName;
        private final boolean autoIncrement;

        public UpdateColumnAutoIncrement(String[] fieldName, boolean autoIncrement) {
            this.fieldName = fieldName;
            this.autoIncrement = autoIncrement;
        }

        @Override
        public String[] fieldName() {
            return this.fieldName;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateColumnAutoIncrement that = (UpdateColumnAutoIncrement)o;
            return this.autoIncrement == that.autoIncrement && Arrays.equals(this.fieldName, that.fieldName);
        }

        public int hashCode() {
            int result = Objects.hash(this.autoIncrement);
            result = 31 * result + Arrays.hashCode(this.fieldName);
            return result;
        }
    }

    public static interface ColumnChange
    extends TableChange {
        public String[] fieldName();
    }

    public static final class Default
    implements ColumnPosition {
        private static final Default INSTANCE = new Default();

        private Default() {
        }

        public String toString() {
            return "DEFAULT";
        }
    }

    public static final class After
    implements ColumnPosition {
        private final String column;

        private After(String column) {
            if (null == column) {
                throw new IllegalArgumentException("column can not be null.");
            }
            this.column = column;
        }

        public String getColumn() {
            return this.column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            After after = (After)o;
            return this.column.equals(after.column);
        }

        public int hashCode() {
            return Objects.hash(this.column);
        }

        public String toString() {
            return "AFTER " + this.column;
        }
    }

    public static final class First
    implements ColumnPosition {
        private static final First INSTANCE = new First();

        private First() {
        }

        public String toString() {
            return "FIRST";
        }
    }
}

