/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.Credential;

public class OSSTokenCredential
implements Credential {
    public static final String OSS_TOKEN_CREDENTIAL_TYPE = "oss-token";
    public static final String GRAVITINO_OSS_SESSION_ACCESS_KEY_ID = "oss-access-key-id";
    public static final String GRAVITINO_OSS_SESSION_SECRET_ACCESS_KEY = "oss-secret-access-key";
    public static final String GRAVITINO_OSS_TOKEN = "oss-security-token";
    private String accessKeyId;
    private String secretAccessKey;
    private String securityToken;
    private long expireTimeInMS;

    public OSSTokenCredential(String accessKeyId, String secretAccessKey, String securityToken, long expireTimeInMS) {
        this.validate(accessKeyId, secretAccessKey, securityToken, expireTimeInMS);
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.securityToken = securityToken;
        this.expireTimeInMS = expireTimeInMS;
    }

    public OSSTokenCredential() {
    }

    @Override
    public String credentialType() {
        return OSS_TOKEN_CREDENTIAL_TYPE;
    }

    @Override
    public long expireTimeInMs() {
        return this.expireTimeInMS;
    }

    @Override
    public Map<String, String> credentialInfo() {
        return new ImmutableMap.Builder<String, String>().put(GRAVITINO_OSS_SESSION_ACCESS_KEY_ID, this.accessKeyId).put(GRAVITINO_OSS_SESSION_SECRET_ACCESS_KEY, this.secretAccessKey).put(GRAVITINO_OSS_TOKEN, this.securityToken).build();
    }

    @Override
    public void initialize(Map<String, String> credentialInfo, long expireTimeInMs) {
        String accessKeyId = credentialInfo.get(GRAVITINO_OSS_SESSION_ACCESS_KEY_ID);
        String secretAccessKey = credentialInfo.get(GRAVITINO_OSS_SESSION_SECRET_ACCESS_KEY);
        String securityToken = credentialInfo.get(GRAVITINO_OSS_TOKEN);
        this.validate(accessKeyId, secretAccessKey, securityToken, expireTimeInMs);
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.securityToken = securityToken;
        this.expireTimeInMS = expireTimeInMs;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    public String securityToken() {
        return this.securityToken;
    }

    private void validate(String accessKeyId, String secretAccessKey, String sessionToken, long expireTimeInMs) {
        Preconditions.checkArgument(StringUtils.isNotBlank(accessKeyId), "OSS access key Id should not be empty");
        Preconditions.checkArgument(StringUtils.isNotBlank(secretAccessKey), "OSS secret access key should not be empty");
        Preconditions.checkArgument(StringUtils.isNotBlank(sessionToken), "OSS session token should not be empty");
        Preconditions.checkArgument(expireTimeInMs > 0L, "The expire time of OSSTokenCredential should great than 0");
    }
}

