/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.model.ModelVersionChange;

public class UpdateModelVersionComment
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String model;
    protected final Integer version;
    private final String alias;
    private final String comment;

    public UpdateModelVersionComment(CommandContext context, String metalake, String catalog, String schema, String model, Integer version, String alias, String comment) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.model = model;
        this.version = version;
        this.alias = alias;
        this.comment = comment;
    }

    @Override
    public void handle() {
        try {
            NameIdentifier modelIdent = NameIdentifier.of(this.schema, this.model);
            GravitinoClient client = this.buildClient(this.metalake);
            ModelVersionChange change = ModelVersionChange.updateComment(this.comment);
            if (this.alias != null) {
                client.loadCatalog(this.catalog).asModelCatalog().alterModelVersion(modelIdent, this.alias, change);
            } else {
                client.loadCatalog(this.catalog).asModelCatalog().alterModelVersion(modelIdent, this.version, change);
            }
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchModelException err) {
            this.exitWithError("Unknown model name.");
        }
        catch (NoSuchModelVersionException err) {
            this.exitWithError("Unknown model version.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (this.alias != null) {
            this.printInformation(this.model + " alias " + this.alias + " comment changed.");
        } else {
            this.printInformation(this.model + " version " + this.version + " comment changed.");
        }
    }

    @Override
    public Command validate() {
        if (this.alias != null && this.version != null) {
            this.exitWithError("Cannot specify both alias and version");
        }
        return this;
    }
}

