/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.model.ModelVersionChange;

public class RemoveModelVersionProperty
extends Command {
    private final String metalake;
    private final String catalog;
    private final String schema;
    private final String model;
    private final Integer version;
    private final String alias;
    private final String property;

    public RemoveModelVersionProperty(CommandContext context, String metalake, String catalog, String schema, String model, Integer version, String alias, String property) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.model = model;
        this.version = version;
        this.alias = alias;
        this.property = property;
    }

    @Override
    public void handle() {
        try {
            NameIdentifier name = NameIdentifier.of(this.schema, this.model);
            GravitinoClient client = this.buildClient(this.metalake);
            ModelVersionChange change = ModelVersionChange.removeProperty(this.property);
            if (this.version != null) {
                client.loadCatalog(this.catalog).asModelCatalog().alterModelVersion(name, this.version, change);
            } else {
                client.loadCatalog(this.catalog).asModelCatalog().alterModelVersion(name, this.alias, change);
            }
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchModelException err) {
            this.exitWithError("Unknown model name.");
        }
        catch (NoSuchModelVersionException err) {
            this.exitWithError("Unknown model version.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (this.alias != null) {
            this.printInformation(this.model + " version " + this.alias + "property " + this.property + " property removed.");
        } else {
            this.printInformation(this.model + " version " + this.version + "property " + this.property + " property removed.");
        }
    }

    @Override
    public Command validate() {
        this.validateProperty(this.property);
        return super.validate();
    }
}

