/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.CommandHandler;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.commands.Command;

public class RoleCommandHandler
extends CommandHandler {
    private final GravitinoCommandLine gravitinoCommandLine;
    private final CommandLine line;
    private final String command;
    private final CommandContext context;
    private String metalake;
    private String[] roles;
    private String[] privileges;

    public RoleCommandHandler(GravitinoCommandLine gravitinoCommandLine, CommandLine line, String command, CommandContext context) {
        this.gravitinoCommandLine = gravitinoCommandLine;
        this.line = line;
        this.command = command;
        this.context = context;
    }

    @Override
    public void handle() {
        String userName = this.line.getOptionValue("login");
        Command.setAuthenticationMode(this.context.auth(), userName);
        this.metalake = new FullName(this.line).getMetalakeName();
        this.roles = this.line.getOptionValues("role");
        if (this.roles == null && !"list".equals(this.command)) {
            System.err.println("Missing --role option.");
            Main.exit(-1);
        }
        if (this.roles != null) {
            this.roles = (String[])Arrays.stream(this.roles).distinct().toArray(String[]::new);
        }
        this.privileges = this.line.getOptionValues("privilege");
        if (!this.executeCommand()) {
            System.err.println("Entity doesn't support this action.");
            Main.exit(-1);
        }
    }

    private boolean executeCommand() {
        switch (this.command) {
            case "details": {
                this.handleDetailsCommand();
                return true;
            }
            case "list": {
                this.handleListCommand();
                return true;
            }
            case "create": {
                this.handleCreateCommand();
                return true;
            }
            case "delete": {
                this.handleDeleteCommand();
                return true;
            }
            case "grant": {
                this.handleGrantCommand();
                return true;
            }
            case "revoke": {
                this.handleRevokeCommand();
                return true;
            }
        }
        return false;
    }

    private void handleDetailsCommand() {
        if (this.line.hasOption("audit")) {
            this.gravitinoCommandLine.newRoleAudit(this.context, this.metalake, this.getOneRole()).validate().handle();
        } else {
            this.gravitinoCommandLine.newRoleDetails(this.context, this.metalake, this.getOneRole()).validate().handle();
        }
    }

    private void handleListCommand() {
        this.gravitinoCommandLine.newListRoles(this.context, this.metalake).validate().handle();
    }

    private void handleCreateCommand() {
        this.gravitinoCommandLine.newCreateRole(this.context, this.metalake, this.roles).validate().handle();
    }

    private void handleDeleteCommand() {
        this.gravitinoCommandLine.newDeleteRole(this.context, this.metalake, this.roles).validate().handle();
    }

    private void handleGrantCommand() {
        this.gravitinoCommandLine.newGrantPrivilegesToRole(this.context, this.metalake, this.getOneRole(), new FullName(this.line), this.privileges).validate().handle();
    }

    private void handleRevokeCommand() {
        boolean removeAll = this.line.hasOption("all");
        if (removeAll) {
            this.gravitinoCommandLine.newRevokeAllPrivileges(this.context, this.metalake, this.getOneRole(), new FullName(this.line)).validate().handle();
        } else {
            this.gravitinoCommandLine.newRevokePrivilegesFromRole(this.context, this.metalake, this.getOneRole(), new FullName(this.line), this.privileges).validate().handle();
        }
    }

    private String getOneRole() {
        if (this.roles == null || this.roles.length != 1) {
            System.err.println("This command only supports one --role option.");
            Main.exit(-1);
        }
        return this.roles[0];
    }
}

