/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.compression.BlockDecompressor;
import org.apache.paimon.io.PageFileInput;
import org.apache.paimon.utils.MathUtils;

public class CompressedPageFileInput
implements PageFileInput {
    private final RandomAccessFile file;
    private final int pageSize;
    private final long uncompressedBytes;
    private final long[] pagePositions;
    private final BlockDecompressor decompressor;
    private final byte[] uncompressedBuffer;
    private final byte[] compressedBuffer;
    private final int pageSizeBits;
    private final int pageSizeMask;

    public CompressedPageFileInput(RandomAccessFile file, int pageSize, BlockCompressionFactory compressionFactory, long uncompressedBytes, long[] pagePositions) {
        this.file = file;
        this.pageSize = pageSize;
        this.uncompressedBytes = uncompressedBytes;
        this.pagePositions = pagePositions;
        this.uncompressedBuffer = new byte[pageSize];
        this.decompressor = compressionFactory.getDecompressor();
        this.compressedBuffer = new byte[compressionFactory.getCompressor().getMaxCompressedSize(pageSize)];
        this.pageSizeBits = MathUtils.log2strict((int)pageSize);
        this.pageSizeMask = pageSize - 1;
    }

    @Override
    public RandomAccessFile file() {
        return this.file;
    }

    @Override
    public long uncompressBytes() {
        return this.uncompressedBytes;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public byte[] readPage(int pageIndex) throws IOException {
        long position = this.pagePositions[pageIndex];
        this.file.seek(position);
        int compressLength = this.file.readInt();
        this.file.readFully(this.compressedBuffer, 0, compressLength);
        int uncompressedLength = this.decompressor.decompress(this.compressedBuffer, 0, compressLength, this.uncompressedBuffer, 0);
        byte[] result = new byte[uncompressedLength];
        System.arraycopy(this.uncompressedBuffer, 0, result, 0, uncompressedLength);
        return result;
    }

    @Override
    public byte[] readPosition(long position, int length) throws IOException {
        int currentLength;
        int offset = (int)(position & (long)this.pageSizeMask);
        int pageIndex = (int)(position >>> this.pageSizeBits);
        byte[] result = new byte[length];
        int n = 0;
        do {
            byte[] page = this.readPage(pageIndex);
            currentLength = Math.min(page.length - offset, length - n);
            System.arraycopy(page, offset, result, n, currentLength);
            offset = 0;
            ++pageIndex;
        } while ((n += currentLength) < length);
        return result;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

