/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.auth;

public class AuthProperties {
    public static final String GRAVITINO_CLIENT_AUTH_TYPE = "authType";
    public static final String SIMPLE_AUTH_TYPE = "simple";
    public static final String OAUTH2_AUTH_TYPE = "oauth2";
    public static final String KERBEROS_AUTH_TYPE = "kerberos";
    public static final String GRAVITINO_OAUTH2_SERVER_URI = "oauth2.serverUri";
    public static final String GRAVITINO_OAUTH2_CREDENTIAL = "oauth2.credential";
    public static final String GRAVITINO_OAUTH2_TOKEN_PATH = "oauth2.tokenPath";
    public static final String GRAVITINO_OAUTH2_SCOPE = "oauth2.scope";

    public static boolean isKerberos(String authType) {
        return KERBEROS_AUTH_TYPE.equalsIgnoreCase(authType);
    }

    public static boolean isOAuth2(String authType) {
        return OAUTH2_AUTH_TYPE.equalsIgnoreCase(authType);
    }

    public static boolean isSimple(String authType) {
        return authType == null || SIMPLE_AUTH_TYPE.equalsIgnoreCase(authType);
    }

    private AuthProperties() {
    }
}

