/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.catalog.property.PropertyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogPropertyConverter
extends PropertyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyConverter.class);
    private static final String TRINO_PROPERTIES_PREFIX = "trino.bypass.";

    public Map<String, String> engineToGravitinoMapping() {
        return ImmutableMap.of();
    }

    public Map<String, String> gravitinoToEngineProperties(Map<String, String> gravitinoProperties) {
        HashMap<String, String> engineProperties = new HashMap<String, String>();
        Map gravitinoToEngineMapping = this.reverseMap(this.engineToGravitinoMapping());
        HashMap<String, String> trinoBypassProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : gravitinoProperties.entrySet()) {
            String gravitinoKey = entry.getKey();
            if (gravitinoKey.startsWith(TRINO_PROPERTIES_PREFIX)) {
                trinoBypassProperties.put(gravitinoKey.replace(TRINO_PROPERTIES_PREFIX, ""), entry.getValue());
                continue;
            }
            String engineKey = (String)gravitinoToEngineMapping.get(gravitinoKey);
            if (engineKey != null) {
                engineProperties.put(engineKey, entry.getValue());
                continue;
            }
            LOG.info("Property {} is not supported by engine", (Object)entry.getKey());
        }
        if (!trinoBypassProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : trinoBypassProperties.entrySet()) {
                String key = entry.getKey();
                if (!engineProperties.containsKey(key)) {
                    engineProperties.put(key, entry.getValue());
                    continue;
                }
                LOG.info("Property {} which with trino.bypass prefix is skipped", (Object)key);
            }
        }
        return engineProperties;
    }
}

