/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.trino.connector.GravitinoColumnHandle;
import org.apache.gravitino.trino.connector.GravitinoConstraint;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.GravitinoHandle;
import org.apache.gravitino.trino.connector.GravitinoInsertTableHandle;
import org.apache.gravitino.trino.connector.GravitinoTableHandle;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorMetadata;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorMetadataAdapter;
import org.apache.gravitino.trino.connector.metadata.GravitinoColumn;
import org.apache.gravitino.trino.connector.metadata.GravitinoSchema;
import org.apache.gravitino.trino.connector.metadata.GravitinoTable;

public class GravitinoMetadata
implements ConnectorMetadata {
    public static final String MERGE_ROW_ID = "$row_id";
    private final CatalogConnectorMetadata catalogConnectorMetadata;
    private final CatalogConnectorMetadataAdapter metadataAdapter;
    private final ConnectorMetadata internalMetadata;

    public GravitinoMetadata(CatalogConnectorMetadata catalogConnectorMetadata, CatalogConnectorMetadataAdapter metadataAdapter, ConnectorMetadata internalMetadata) {
        this.catalogConnectorMetadata = catalogConnectorMetadata;
        this.metadataAdapter = metadataAdapter;
        this.internalMetadata = internalMetadata;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.catalogConnectorMetadata.listSchemaNames();
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, String schemaName) {
        GravitinoSchema schema = this.catalogConnectorMetadata.getSchema(schemaName);
        return this.metadataAdapter.getSchemaProperties(schema);
    }

    public GravitinoTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        boolean tableExists = this.catalogConnectorMetadata.tableExists(tableName.getSchemaName(), tableName.getTableName());
        if (!tableExists) {
            return null;
        }
        ConnectorTableHandle internalTableHandle = this.internalMetadata.getTableHandle(session, tableName, startVersion, endVersion);
        if (internalTableHandle == null) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_TABLE_NOT_EXISTS, String.format("Table %s does not exist in the internal connector", tableName));
        }
        return new GravitinoTableHandle(tableName.getSchemaName(), tableName.getTableName(), internalTableHandle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        GravitinoTableHandle gravitinoTableHandle = (GravitinoTableHandle)tableHandle;
        GravitinoTable table = this.catalogConnectorMetadata.getTable(gravitinoTableHandle.getSchemaName(), gravitinoTableHandle.getTableName());
        return this.metadataAdapter.getTableMetadata(table);
    }

    public SchemaTableName getTableName(ConnectorSession session, ConnectorTableHandle table) {
        return this.getTableName(table);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> optionalSchemaName) {
        Set schemaNames = (Set)optionalSchemaName.map(ImmutableSet::of).orElseGet(() -> ImmutableSet.copyOf(this.listSchemaNames(session)));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String schemaName : schemaNames) {
            List<String> tableNames = this.catalogConnectorMetadata.listTables(schemaName);
            for (String tableName : tableNames) {
                builder.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Map internalColumnHandles = this.internalMetadata.getColumnHandles(session, GravitinoHandle.unWrap(tableHandle));
        return internalColumnHandles.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new GravitinoColumnHandle((String)entry.getKey(), (ColumnHandle)entry.getValue())));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return this.internalMetadata.getColumnMetadata(session, GravitinoHandle.unWrap(tableHandle), GravitinoHandle.unWrap(columnHandle));
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, SaveMode saveMode) {
        GravitinoTable table = this.metadataAdapter.createTable(tableMetadata);
        this.catalogConnectorMetadata.createTable(table, saveMode == SaveMode.IGNORE);
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        GravitinoSchema schema = this.metadataAdapter.createSchema(schemaName, properties);
        this.catalogConnectorMetadata.createSchema(schema);
    }

    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        this.catalogConnectorMetadata.dropSchema(schemaName, cascade);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.catalogConnectorMetadata.dropTable(this.getTableName(tableHandle));
    }

    public void beginQuery(ConnectorSession session) {
        this.internalMetadata.beginQuery(session);
    }

    public void cleanupQuery(ConnectorSession session) {
        this.internalMetadata.cleanupQuery(session);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        ConnectorInsertTableHandle insertTableHandle = this.internalMetadata.beginInsert(session, GravitinoHandle.unWrap(tableHandle), GravitinoHandle.unWrap(columns), retryMode);
        return new GravitinoInsertTableHandle(insertTableHandle);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return this.internalMetadata.finishInsert(session, GravitinoHandle.unWrap(insertHandle), fragments, computedStatistics);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        this.catalogConnectorMetadata.renameSchema(source, target);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        this.catalogConnectorMetadata.renameTable(this.getTableName(tableHandle), newTableName);
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        this.catalogConnectorMetadata.setTableComment(this.getTableName(tableHandle), comment.orElse(""));
    }

    public void setTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Optional<Object>> properties) {
        Map<String, Object> resultMap = properties.entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Optional)e.getValue()).get()));
        Map<String, String> allProps = this.metadataAdapter.toGravitinoTableProperties(resultMap);
        this.catalogConnectorMetadata.setTableProperties(this.getTableName(tableHandle), allProps);
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        GravitinoColumn gravitinoColumn = this.metadataAdapter.createColumn(column);
        this.catalogConnectorMetadata.addColumn(this.getTableName(tableHandle), gravitinoColumn);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        String columnName = this.getColumnName(column);
        this.catalogConnectorMetadata.dropColumn(this.getTableName(tableHandle), columnName);
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        String columnName = this.getColumnName(source);
        this.catalogConnectorMetadata.renameColumn(this.getTableName(tableHandle), columnName, target);
    }

    public void setColumnType(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Type type) {
        String columnName = this.getColumnName(column);
        this.catalogConnectorMetadata.setColumnType(this.getTableName(tableHandle), columnName, this.metadataAdapter.getDataTypeTransformer().getGravitinoType(type));
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        String columnName = this.getColumnName(column);
        String commentString = "";
        if (comment.isPresent() && !StringUtils.isBlank((CharSequence)comment.get())) {
            commentString = comment.get();
        }
        this.catalogConnectorMetadata.setColumnComment(this.getTableName(tableHandle), columnName, commentString);
    }

    public Optional<JoinApplicationResult<ConnectorTableHandle>> applyJoin(ConnectorSession session, JoinType joinType, ConnectorTableHandle left, ConnectorTableHandle right, ConnectorExpression joinCondition, Map<String, ColumnHandle> leftAssignments, Map<String, ColumnHandle> rightAssignments, JoinStatistics statistics) {
        return this.internalMetadata.applyJoin(session, joinType, GravitinoHandle.unWrap(left), GravitinoHandle.unWrap(right), joinCondition, leftAssignments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> GravitinoHandle.unWrap((ColumnHandle)entry.getValue()))), rightAssignments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> GravitinoHandle.unWrap((ColumnHandle)entry.getValue()))), statistics).map(result -> new JoinApplicationResult((Object)new GravitinoTableHandle(this.getTableName(left).getSchemaName(), this.getTableName(left).getTableName(), (ConnectorTableHandle)result.getTableHandle()), result.getLeftColumnHandles().entrySet().stream().collect(Collectors.toMap(entry -> new GravitinoColumnHandle(this.getColumnName(session, GravitinoHandle.unWrap(left), (ColumnHandle)entry.getKey()), (ColumnHandle)entry.getKey()), entry -> new GravitinoColumnHandle(this.getColumnName(session, GravitinoHandle.unWrap(left), (ColumnHandle)entry.getValue()), (ColumnHandle)entry.getValue()))), result.getRightColumnHandles().entrySet().stream().collect(Collectors.toMap(entry -> new GravitinoColumnHandle(this.getColumnName(session, GravitinoHandle.unWrap(right), (ColumnHandle)entry.getKey()), (ColumnHandle)entry.getKey()), entry -> new GravitinoColumnHandle(this.getColumnName(session, GravitinoHandle.unWrap(right), (ColumnHandle)entry.getValue()), (ColumnHandle)entry.getValue()))), result.isPrecalculateStatistics()));
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        return this.internalMetadata.applyProjection(session, GravitinoHandle.unWrap(handle), projections, assignments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> GravitinoHandle.unWrap((ColumnHandle)entry.getValue())))).map(result -> new ProjectionApplicationResult((Object)new GravitinoTableHandle(this.getTableName(handle).getSchemaName(), this.getTableName(handle).getTableName(), (ConnectorTableHandle)result.getHandle()), result.getProjections(), result.getAssignments().stream().map(entry -> new Assignment(entry.getVariable(), (ColumnHandle)new GravitinoColumnHandle(this.getColumnName(session, GravitinoHandle.unWrap(handle), entry.getColumn()), entry.getColumn()), entry.getType())).toList(), result.isPrecalculateStatistics()));
    }

    public ColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ColumnHandle mergeRowIdColumnHandle = this.internalMetadata.getMergeRowIdColumnHandle(session, GravitinoHandle.unWrap(tableHandle));
        return new GravitinoColumnHandle(MERGE_ROW_ID, mergeRowIdColumnHandle);
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        return this.internalMetadata.applyFilter(session, GravitinoHandle.unWrap(tableHandle), (Constraint)new GravitinoConstraint(constraint)).map(result -> new ConstraintApplicationResult((Object)new GravitinoTableHandle(this.getTableName(tableHandle).getSchemaName(), this.getTableName(tableHandle).getTableName(), (ConnectorTableHandle)result.getHandle()), result.getRemainingFilter().transformKeys(columnHandle -> new GravitinoColumnHandle(this.getColumnName(session, GravitinoHandle.unWrap(tableHandle), (ColumnHandle)columnHandle), (ColumnHandle)columnHandle)), (ConnectorExpression)result.getRemainingExpression().get(), result.isPrecalculateStatistics()));
    }

    public Optional<AggregationApplicationResult<ConnectorTableHandle>> applyAggregation(ConnectorSession session, ConnectorTableHandle handle, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return this.internalMetadata.applyAggregation(session, GravitinoHandle.unWrap(handle), aggregates, assignments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> GravitinoHandle.unWrap((ColumnHandle)entry.getValue()))), groupingSets.stream().map(innerList -> innerList.stream().map(GravitinoHandle::unWrap).collect(Collectors.toList())).collect(Collectors.toList())).map(result -> new AggregationApplicationResult((Object)new GravitinoTableHandle(this.getTableName(handle).getSchemaName(), this.getTableName(handle).getTableName(), (ConnectorTableHandle)result.getHandle()), result.getProjections(), result.getAssignments().stream().map(entry -> new Assignment(entry.getVariable(), (ColumnHandle)new GravitinoColumnHandle(this.getColumnName(session, GravitinoHandle.unWrap(handle), entry.getColumn()), entry.getColumn()), entry.getType())).toList(), result.getGroupingColumnMapping().entrySet().stream().collect(Collectors.toMap(entry -> new GravitinoColumnHandle(this.getColumnName(session, GravitinoHandle.unWrap(handle), (ColumnHandle)entry.getKey()), (ColumnHandle)entry.getKey()), entry -> new GravitinoColumnHandle(this.getColumnName(session, GravitinoHandle.unWrap(handle), (ColumnHandle)entry.getValue()), (ColumnHandle)entry.getValue()))), result.isPrecalculateStatistics()));
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle handle, long limit) {
        return this.internalMetadata.applyLimit(session, GravitinoHandle.unWrap(handle), limit).map(result -> new LimitApplicationResult((Object)new GravitinoTableHandle(this.getTableName(handle).getSchemaName(), this.getTableName(handle).getTableName(), (ConnectorTableHandle)result.getHandle()), result.isLimitGuaranteed(), result.isPrecalculateStatistics()));
    }

    public Optional<TopNApplicationResult<ConnectorTableHandle>> applyTopN(ConnectorSession session, ConnectorTableHandle handle, long topNCount, List<SortItem> sortItems, Map<String, ColumnHandle> assignments) {
        return this.internalMetadata.applyTopN(session, GravitinoHandle.unWrap(handle), topNCount, sortItems, assignments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> GravitinoHandle.unWrap((ColumnHandle)entry.getValue())))).map(result -> new TopNApplicationResult((Object)new GravitinoTableHandle(this.getTableName(handle).getSchemaName(), this.getTableName(handle).getTableName(), (ConnectorTableHandle)result.getHandle()), result.isTopNGuaranteed(), result.isPrecalculateStatistics()));
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.internalMetadata.getTableStatistics(session, GravitinoHandle.unWrap(tableHandle));
    }

    public Optional<ConnectorTableHandle> applyUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, Map<ColumnHandle, Constant> assignments) {
        return this.internalMetadata.applyUpdate(session, GravitinoHandle.unWrap(tableHandle), assignments.entrySet().stream().collect(Collectors.toMap(entry -> GravitinoHandle.unWrap((ColumnHandle)entry.getKey()), Map.Entry::getValue))).map(result -> new GravitinoTableHandle(this.getTableName(tableHandle).getSchemaName(), this.getTableName(tableHandle).getTableName(), (ConnectorTableHandle)result));
    }

    public RowChangeParadigm getRowChangeParadigm(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.internalMetadata.getRowChangeParadigm(session, GravitinoHandle.unWrap(tableHandle));
    }

    public OptionalLong executeUpdate(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.internalMetadata.executeUpdate(session, GravitinoHandle.unWrap(tableHandle));
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.internalMetadata.applyDelete(session, GravitinoHandle.unWrap(tableHandle)).map(result -> new GravitinoTableHandle(this.getTableName(tableHandle).getSchemaName(), this.getTableName(tableHandle).getTableName(), (ConnectorTableHandle)result));
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.internalMetadata.executeDelete(session, GravitinoHandle.unWrap(tableHandle));
    }

    private SchemaTableName getTableName(ConnectorTableHandle tableHandle) {
        return ((GravitinoTableHandle)tableHandle).toSchemaTableName();
    }

    private String getColumnName(ColumnHandle columnHandle) {
        return ((GravitinoColumnHandle)columnHandle).getColumnName();
    }

    private String getColumnName(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        ColumnMetadata internalMetadataColumnMetadata = this.internalMetadata.getColumnMetadata(session, tableHandle, columnHandle);
        if (internalMetadataColumnMetadata == null) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_COLUMN_NOT_EXISTS, String.format("Column %s does not exist in the internal connector", columnHandle));
        }
        return internalMetadataColumnMetadata.getName();
    }
}

