/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.gravitino.client.AuthDataProvider;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public abstract class CustomTokenProvider
implements AuthDataProvider {
    private static final String BLANK_SPACE = " ";
    protected String schemeName;

    @Override
    public boolean hasTokenData() {
        return true;
    }

    @Override
    public byte[] getTokenData() {
        return (this.schemeName + BLANK_SPACE + this.getCustomTokenInfo()).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void close() throws IOException {
    }

    protected abstract String getCustomTokenInfo();

    public static abstract class CustomTokenProviderBuilder<SELF extends Builder<SELF, T>, T extends CustomTokenProvider>
    implements Builder<SELF, T> {
        protected String schemeName;

        @Override
        public SELF withSchemeName(String schemeName) {
            this.schemeName = schemeName;
            return this.self();
        }

        @Override
        public T build() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.schemeName), "CustomTokenProvider must set schemeName");
            T t2 = this.internalBuild();
            return t2;
        }

        protected abstract T internalBuild();

        private SELF self() {
            return (SELF)this;
        }
    }

    protected static interface Builder<SELF extends Builder<SELF, T>, T extends CustomTokenProvider> {
        public SELF withSchemeName(String var1);

        public T build();
    }
}

