/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.policy.PolicyContentDTO;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.policy.PolicyChange;
import org.apache.gravitino.policy.PolicyContent;
import org.apache.gravitino.rest.RESTRequest;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=RenamePolicyRequest.class, name="rename"), @JsonSubTypes.Type(value=UpdatePolicyCommentRequest.class, name="updateComment"), @JsonSubTypes.Type(value=UpdatePolicyContentRequest.class, name="updateContent")})
public interface PolicyUpdateRequest
extends RESTRequest {
    public PolicyChange policyChange();

    public static class UpdatePolicyContentRequest
    implements PolicyUpdateRequest {
        @JsonProperty(value="policyType")
        private final String policyType;
        @JsonProperty(value="newContent")
        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="policyType", defaultImpl=PolicyContentDTO.CustomContentDTO.class)
        @JsonSubTypes(value={})
        private final PolicyContentDTO newContent;

        public UpdatePolicyContentRequest(String policyType, PolicyContentDTO newContent) {
            this.policyType = policyType;
            this.newContent = newContent;
        }

        private UpdatePolicyContentRequest() {
            this(null, null);
        }

        @Override
        public PolicyChange policyChange() {
            return PolicyChange.updateContent((String)this.policyType, (PolicyContent)DTOConverters.fromDTO(this.newContent));
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((this.newContent != null ? 1 : 0) != 0, (Object)"\"newContent\" must not be null");
            this.newContent.validate();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdatePolicyContentRequest)) {
                return false;
            }
            UpdatePolicyContentRequest other = (UpdatePolicyContentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$policyType = this.getPolicyType();
            String other$policyType = other.getPolicyType();
            if (this$policyType == null ? other$policyType != null : !this$policyType.equals(other$policyType)) {
                return false;
            }
            PolicyContentDTO this$newContent = this.getNewContent();
            PolicyContentDTO other$newContent = other.getNewContent();
            return !(this$newContent == null ? other$newContent != null : !this$newContent.equals(other$newContent));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdatePolicyContentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $policyType = this.getPolicyType();
            result = result * 59 + ($policyType == null ? 43 : $policyType.hashCode());
            PolicyContentDTO $newContent = this.getNewContent();
            result = result * 59 + ($newContent == null ? 43 : $newContent.hashCode());
            return result;
        }

        public String getPolicyType() {
            return this.policyType;
        }

        public PolicyContentDTO getNewContent() {
            return this.newContent;
        }

        public String toString() {
            return "PolicyUpdateRequest.UpdatePolicyContentRequest(policyType=" + this.getPolicyType() + ", newContent=" + String.valueOf(this.getNewContent()) + ")";
        }
    }

    public static class UpdatePolicyCommentRequest
    implements PolicyUpdateRequest {
        @JsonProperty(value="newComment")
        private final String newComment;

        public UpdatePolicyCommentRequest(String newComment) {
            this.newComment = newComment;
        }

        private UpdatePolicyCommentRequest() {
            this(null);
        }

        @Override
        public PolicyChange policyChange() {
            return PolicyChange.updateComment((String)this.newComment);
        }

        @Override
        public void validate() throws IllegalArgumentException {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdatePolicyCommentRequest)) {
                return false;
            }
            UpdatePolicyCommentRequest other = (UpdatePolicyCommentRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newComment = this.getNewComment();
            String other$newComment = other.getNewComment();
            return !(this$newComment == null ? other$newComment != null : !this$newComment.equals(other$newComment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdatePolicyCommentRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newComment = this.getNewComment();
            result = result * 59 + ($newComment == null ? 43 : $newComment.hashCode());
            return result;
        }

        public String toString() {
            return "PolicyUpdateRequest.UpdatePolicyCommentRequest(newComment=" + this.getNewComment() + ")";
        }

        public String getNewComment() {
            return this.newComment;
        }
    }

    public static class RenamePolicyRequest
    implements PolicyUpdateRequest {
        @JsonProperty(value="newName")
        private final String newName;

        public RenamePolicyRequest(String newName) {
            this.newName = newName;
        }

        private RenamePolicyRequest() {
            this(null);
        }

        @Override
        public PolicyChange policyChange() {
            return PolicyChange.rename((String)this.newName);
        }

        @Override
        public void validate() throws IllegalArgumentException {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.newName), (Object)"\"newName\" must not be blank");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenamePolicyRequest)) {
                return false;
            }
            RenamePolicyRequest other = (RenamePolicyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$newName = this.getNewName();
            String other$newName = other.getNewName();
            return !(this$newName == null ? other$newName != null : !this$newName.equals(other$newName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RenamePolicyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $newName = this.getNewName();
            result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
            return result;
        }

        public String getNewName() {
            return this.newName;
        }

        public String toString() {
            return "PolicyUpdateRequest.RenamePolicyRequest(newName=" + this.getNewName() + ")";
        }
    }
}

