/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import java.util.List;
import org.apache.gravitino.storage.relational.po.PolicyPO;
import org.apache.ibatis.annotations.Param;

public class PolicyMetaBaseSQLProvider {
    public String listPolicyPOsByMetalake(@Param(value="metalakeName") String metalakeName) {
        return "SELECT pm.policy_id, pm.policy_name, pm.policy_type, pm.metalake_id, pm.audit_info, pm.current_version, pm.last_version, pm.deleted_at, pvi.id, pvi.metalake_id as version_metalake_id, pvi.policy_id as version_policy_id, pvi.version, pvi.policy_comment, pvi.enabled, pvi.content, pvi.deleted_at as version_deleted_at FROM policy_meta pm JOIN metalake_meta mm ON pm.metalake_id = mm.metalake_id JOIN policy_version_info pvi ON pm.policy_id = pvi.policy_id AND pm.current_version = pvi.version WHERE mm.metalake_name = #{metalakeName} AND pm.deleted_at = 0 AND mm.deleted_at = 0 AND pvi.deleted_at = 0";
    }

    public String listPolicyPOsByMetalakeAndPolicyNames(@Param(value="metalakeName") String metalakeName, @Param(value="policyNames") List<String> policyNames) {
        return "<script>SELECT pm.policy_id, pm.policy_name, pm.policy_type, pm.metalake_id, pm.audit_info, pm.current_version, pm.last_version, pm.deleted_at, pvi.id, pvi.metalake_id as version_metalake_id, pvi.policy_id as version_policy_id, pvi.version, pvi.policy_comment, pvi.enabled, pvi.content, pvi.deleted_at as version_deleted_at FROM policy_meta pm JOIN metalake_meta mm ON pm.metalake_id = mm.metalake_id JOIN policy_version_info pvi ON pm.policy_id = pvi.policy_id AND pm.current_version = pvi.version WHERE mm.metalake_name = #{metalakeName} AND pm.policy_name IN  <foreach item='policyName' index='index' collection='policyNames' open='(' separator=',' close=')'> #{policyName} </foreach> AND pm.deleted_at = 0 AND mm.deleted_at = 0 AND pvi.deleted_at = 0</script>";
    }

    public String insertPolicyMetaOnDuplicateKeyUpdate(@Param(value="policyMeta") PolicyPO policyPO) {
        return "INSERT INTO policy_meta (policy_id, policy_name, policy_type, metalake_id, audit_info, current_version, last_version, deleted_at) VALUES (#{policyMeta.policyId}, #{policyMeta.policyName}, #{policyMeta.policyType}, #{policyMeta.metalakeId}, #{policyMeta.auditInfo}, #{policyMeta.currentVersion}, #{policyMeta.lastVersion}, #{policyMeta.deletedAt}) ON DUPLICATE KEY UPDATE policy_name = #{policyMeta.policyName}, policy_type = #{policyMeta.policyType}, metalake_id = #{policyMeta.metalakeId}, audit_info = #{policyMeta.auditInfo}, current_version = #{policyMeta.currentVersion}, last_version = #{policyMeta.lastVersion}, deleted_at = #{policyMeta.deletedAt}";
    }

    public String insertPolicyMeta(@Param(value="policyMeta") PolicyPO policyPO) {
        return "INSERT INTO policy_meta (policy_id, policy_name, policy_type, metalake_id, audit_info, current_version, last_version, deleted_at) VALUES (#{policyMeta.policyId}, #{policyMeta.policyName}, #{policyMeta.policyType}, #{policyMeta.metalakeId}, #{policyMeta.auditInfo}, #{policyMeta.currentVersion}, #{policyMeta.lastVersion}, #{policyMeta.deletedAt})";
    }

    public String selectPolicyMetaByMetalakeAndName(@Param(value="metalakeName") String metalakeName, @Param(value="policyName") String policyName) {
        return "SELECT pm.policy_id, pm.policy_name, pm.policy_type, pm.metalake_id, pm.audit_info, pm.current_version, pm.last_version, pm.deleted_at, pvi.id, pvi.metalake_id as version_metalake_id, pvi.policy_id as version_policy_id, pvi.version, pvi.policy_comment, pvi.enabled, pvi.content, pvi.deleted_at as version_deleted_at FROM policy_meta pm JOIN metalake_meta mm ON pm.metalake_id = mm.metalake_id JOIN policy_version_info pvi ON pm.policy_id = pvi.policy_id AND pm.current_version = pvi.version WHERE mm.metalake_name = #{metalakeName} AND pm.policy_name = #{policyName} AND pm.deleted_at = 0 AND mm.deleted_at = 0 AND pvi.deleted_at = 0";
    }

    public String updatePolicyMeta(@Param(value="newPolicyMeta") PolicyPO newPolicyMeta, @Param(value="oldPolicyMeta") PolicyPO oldPolicyMeta) {
        return "UPDATE policy_meta SET policy_name = #{newPolicyMeta.policyName}, policy_type = #{newPolicyMeta.policyType}, metalake_id = #{newPolicyMeta.metalakeId}, audit_info = #{newPolicyMeta.auditInfo}, current_version = #{newPolicyMeta.currentVersion}, last_version = #{newPolicyMeta.lastVersion}, deleted_at = #{newPolicyMeta.deletedAt} WHERE policy_id = #{oldPolicyMeta.policyId} AND policy_name = #{oldPolicyMeta.policyName} AND policy_type = #{oldPolicyMeta.policyType} AND metalake_id = #{oldPolicyMeta.metalakeId} AND audit_info = #{oldPolicyMeta.auditInfo} AND current_version = #{oldPolicyMeta.currentVersion} AND last_version = #{oldPolicyMeta.lastVersion} AND deleted_at = 0";
    }

    public String softDeletePolicyByMetalakeAndPolicyName(@Param(value="metalakeName") String metalakeName, @Param(value="policyName") String policyName) {
        return "UPDATE policy_meta pm SET pm.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE pm.metalake_id IN ( SELECT mm.metalake_id FROM metalake_meta mm WHERE mm.metalake_name = #{metalakeName} AND mm.deleted_at = 0) AND pm.policy_name = #{policyName} AND pm.deleted_at = 0";
    }

    public String deletePolicyMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM policy_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }

    public String softDeletePolicyMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE policy_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }
}

