/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchIcebergViewException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hive.CachedClientPool;
import org.apache.iceberg.hive.HiveHadoopUtil;
import org.apache.iceberg.hive.HiveOperationsBase;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.hive.HiveViewOperations;
import org.apache.iceberg.hive.MetastoreUtil;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.LocationUtil;
import org.apache.iceberg.view.BaseMetastoreViewCatalog;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewBuilder;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewOperations;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalog
extends BaseMetastoreViewCatalog
implements SupportsNamespaces,
Configurable {
    public static final String LIST_ALL_TABLES = "list-all-tables";
    public static final String LIST_ALL_TABLES_DEFAULT = "false";
    public static final String HMS_TABLE_OWNER = "hive.metastore.table.owner";
    public static final String HMS_DB_OWNER = "hive.metastore.database.owner";
    public static final String HMS_DB_OWNER_TYPE = "hive.metastore.database.owner-type";
    static final String HIVE_CONF_CATALOG = "metastore.catalog.default";
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalog.class);
    private String name;
    private Configuration conf;
    private FileIO fileIO;
    private ClientPool<IMetaStoreClient, TException> clients;
    private boolean listAllTables = false;
    private Map<String, String> catalogProperties;

    public void initialize(String inputName, Map<String, String> properties) {
        this.catalogProperties = ImmutableMap.copyOf(properties);
        this.name = inputName;
        if (this.conf == null) {
            LOG.warn("No Hadoop Configuration was set, using the default environment Configuration");
            this.conf = new Configuration();
        }
        if (properties.containsKey("uri")) {
            this.conf.set(HiveConf.ConfVars.METASTOREURIS.varname, properties.get("uri"));
        }
        if (properties.containsKey("warehouse")) {
            this.conf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, LocationUtil.stripTrailingSlash((String)properties.get("warehouse")));
        }
        this.listAllTables = Boolean.parseBoolean(properties.getOrDefault(LIST_ALL_TABLES, LIST_ALL_TABLES_DEFAULT));
        String fileIOImpl = properties.get("io-impl");
        this.fileIO = fileIOImpl == null ? new HadoopFileIO(this.conf) : CatalogUtil.loadFileIO((String)fileIOImpl, properties, (Object)this.conf);
        this.clients = new CachedClientPool(this.conf, properties);
    }

    public Catalog.TableBuilder buildTable(TableIdentifier identifier, Schema schema) {
        return new ViewAwareTableBuilder(identifier, schema);
    }

    public ViewBuilder buildView(TableIdentifier identifier) {
        return new TableAwareViewBuilder(identifier);
    }

    public List<TableIdentifier> listTables(Namespace namespace) {
        Preconditions.checkArgument((boolean)this.isValidateNamespace(namespace), (String)"Missing database in namespace: %s", (Object)namespace);
        String database = namespace.level(0);
        try {
            List tableNames = (List)this.clients.run(client -> client.getAllTables(database));
            List<Object> tableIdentifiers = this.listAllTables ? tableNames.stream().map(t -> TableIdentifier.of((Namespace)namespace, (String)t)).collect(Collectors.toList()) : this.listIcebergTables(tableNames, namespace, "iceberg");
            LOG.debug("Listing of namespace: {} resulted in the following tables: {}", (Object)namespace, tableIdentifiers);
            return tableIdentifiers;
        }
        catch (UnknownDBException e) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all tables under namespace " + String.valueOf(namespace), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to listTables", e);
        }
    }

    public List<TableIdentifier> listViews(Namespace namespace) {
        Preconditions.checkArgument((boolean)this.isValidateNamespace(namespace), (String)"Missing database in namespace: %s", (Object)namespace);
        try {
            String database = namespace.level(0);
            List viewNames = (List)this.clients.run(client -> client.getTables(database, "*", TableType.VIRTUAL_VIEW));
            ArrayList filteredTableIdentifiers = Lists.newArrayList();
            Iterable viewNameSets = Iterables.partition((Iterable)viewNames, (int)100);
            for (List viewNameSet : viewNameSets) {
                filteredTableIdentifiers.addAll(this.listIcebergTables(viewNameSet, namespace, "iceberg-view"));
            }
            return filteredTableIdentifiers;
        }
        catch (UnknownDBException e) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all views under namespace " + String.valueOf(namespace), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to listViews", e);
        }
    }

    public String name() {
        return this.name;
    }

    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        if (!this.isValidIdentifier(identifier)) {
            return false;
        }
        String database = identifier.namespace().level(0);
        TableOperations ops = this.newTableOps(identifier);
        TableMetadata lastMetadata = null;
        if (purge) {
            try {
                lastMetadata = ops.current();
            }
            catch (NotFoundException e) {
                LOG.warn("Failed to load table metadata for table: {}, continuing drop without purge", (Object)identifier, (Object)e);
            }
        }
        try {
            this.clients.run(client -> {
                client.dropTable(database, identifier.name(), false, false);
                return null;
            });
            if (purge && lastMetadata != null) {
                CatalogUtil.dropTableData((FileIO)ops.io(), (TableMetadata)lastMetadata);
            }
            LOG.info("Dropped table: {}", (Object)identifier);
            return true;
        }
        catch (NoSuchObjectException | NoSuchTableException e) {
            LOG.info("Skipping drop, table does not exist: {}", (Object)identifier, (Object)e);
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop " + String.valueOf(identifier), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to dropTable", e);
        }
    }

    public boolean dropView(TableIdentifier identifier) {
        if (!this.isValidIdentifier(identifier)) {
            return false;
        }
        try {
            String database = identifier.namespace().level(0);
            String viewName = identifier.name();
            HiveViewOperations ops = (HiveViewOperations)this.newViewOps(identifier);
            ViewMetadata lastViewMetadata = null;
            try {
                lastViewMetadata = ops.current();
            }
            catch (NotFoundException e) {
                LOG.warn("Failed to load view metadata for view: {}", (Object)identifier, (Object)e);
            }
            this.clients.run(client -> {
                client.dropTable(database, viewName, false, false);
                return null;
            });
            if (lastViewMetadata != null) {
                CatalogUtil.dropViewMetadata((FileIO)ops.io(), (ViewMetadata)lastViewMetadata);
            }
            LOG.info("Dropped view: {}", (Object)identifier);
            return true;
        }
        catch (NoSuchObjectException e) {
            LOG.info("Skipping drop, view does not exist: {}", (Object)identifier, (Object)e);
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop view " + String.valueOf(identifier), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to dropView", e);
        }
    }

    public void renameTable(TableIdentifier from, TableIdentifier originalTo) {
        this.renameTableOrView(from, originalTo, HiveOperationsBase.ContentType.TABLE);
    }

    public void renameView(TableIdentifier from, TableIdentifier to) {
        this.renameTableOrView(from, to, HiveOperationsBase.ContentType.VIEW);
    }

    private List<TableIdentifier> listIcebergTables(List<String> tableNames, Namespace namespace, String tableTypeProp) throws TException, InterruptedException {
        List tableObjects = (List)this.clients.run(client -> client.getTableObjectsByName(namespace.level(0), tableNames));
        return tableObjects.stream().filter(table -> table.getParameters() != null && tableTypeProp.equalsIgnoreCase((String)table.getParameters().get("table_type"))).map(table -> TableIdentifier.of((Namespace)namespace, (String)table.getTableName())).collect(Collectors.toList());
    }

    private void renameTableOrView(TableIdentifier from, TableIdentifier originalTo, HiveOperationsBase.ContentType contentType) {
        Preconditions.checkArgument((boolean)this.isValidIdentifier(from), (String)"Invalid identifier: %s", (Object)from);
        TableIdentifier to = this.removeCatalogName(originalTo);
        Preconditions.checkArgument((boolean)this.isValidIdentifier(to), (String)"Invalid identifier: %s", (Object)to);
        if (!this.namespaceExists(to.namespace())) {
            throw new NoSuchNamespaceException("Cannot rename %s to %s. Namespace does not exist: %s", new Object[]{from, to, to.namespace()});
        }
        if (this.tableExists(to)) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException("Cannot rename %s to %s. Table already exists", new Object[]{from, to});
        }
        if (this.viewExists(to)) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException("Cannot rename %s to %s. View already exists", new Object[]{from, to});
        }
        String toDatabase = to.namespace().level(0);
        String fromDatabase = from.namespace().level(0);
        String fromName = from.name();
        try {
            org.apache.hadoop.hive.metastore.api.Table table = (org.apache.hadoop.hive.metastore.api.Table)this.clients.run(client -> client.getTable(fromDatabase, fromName));
            this.validateTableIsIcebergTableOrView(contentType, table, CatalogUtil.fullTableName((String)this.name, (TableIdentifier)from));
            table.setDbName(toDatabase);
            table.setTableName(to.name());
            this.clients.run(client -> {
                MetastoreUtil.alterTable(client, fromDatabase, fromName, table);
                return null;
            });
            LOG.info("Renamed {} from {}, to {}", new Object[]{contentType.value(), from, to});
        }
        catch (NoSuchObjectException e) {
            switch (contentType) {
                case TABLE: {
                    throw new NoSuchTableException("Cannot rename %s to %s. Table does not exist", new Object[]{from, to});
                }
                case VIEW: {
                    throw new NoSuchViewException("Cannot rename %s to %s. View does not exist", new Object[]{from, to});
                }
            }
        }
        catch (InvalidOperationException e) {
            if (e.getMessage() != null && e.getMessage().contains(String.format("new table %s already exists", to))) {
                throw new org.apache.iceberg.exceptions.AlreadyExistsException("Table already exists: %s", new Object[]{to});
            }
            throw new RuntimeException("Failed to rename " + String.valueOf(from) + " to " + String.valueOf(to), e);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to rename " + String.valueOf(from) + " to " + String.valueOf(to), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to rename", e);
        }
    }

    private void validateTableIsIcebergTableOrView(HiveOperationsBase.ContentType contentType, org.apache.hadoop.hive.metastore.api.Table table, String fullName) {
        switch (contentType) {
            case TABLE: {
                HiveOperationsBase.validateTableIsIceberg(table, fullName);
                break;
            }
            case VIEW: {
                HiveOperationsBase.validateTableIsIcebergView(table, fullName);
            }
        }
    }

    public boolean tableExists(TableIdentifier identifier) {
        TableIdentifier baseTableIdentifier = identifier;
        if (!this.isValidIdentifier(identifier)) {
            if (!this.isValidMetadataIdentifier(identifier)) {
                return false;
            }
            baseTableIdentifier = TableIdentifier.of((String[])identifier.namespace().levels());
        }
        String database = baseTableIdentifier.namespace().level(0);
        String tableName = baseTableIdentifier.name();
        try {
            org.apache.hadoop.hive.metastore.api.Table table = (org.apache.hadoop.hive.metastore.api.Table)this.clients.run(client -> client.getTable(database, tableName));
            HiveOperationsBase.validateTableIsIceberg(table, HiveCatalog.fullTableName((String)this.name, (TableIdentifier)baseTableIdentifier));
            return true;
        }
        catch (NoSuchObjectException | NoSuchTableException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to check table existence of " + String.valueOf(baseTableIdentifier), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to check table existence of " + String.valueOf(baseTableIdentifier), e);
        }
    }

    public boolean viewExists(TableIdentifier viewIdentifier) {
        if (!this.isValidIdentifier(viewIdentifier)) {
            return false;
        }
        String database = viewIdentifier.namespace().level(0);
        String viewName = viewIdentifier.name();
        try {
            org.apache.hadoop.hive.metastore.api.Table table = (org.apache.hadoop.hive.metastore.api.Table)this.clients.run(client -> client.getTable(database, viewName));
            HiveOperationsBase.validateTableIsIcebergView(table, HiveCatalog.fullTableName((String)this.name, (TableIdentifier)viewIdentifier));
            return true;
        }
        catch (NoSuchObjectException | NoSuchIcebergViewException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to check view existence of " + String.valueOf(viewIdentifier), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to check view existence of " + String.valueOf(viewIdentifier), e);
        }
    }

    public void createNamespace(Namespace namespace, Map<String, String> meta) {
        Preconditions.checkArgument((!namespace.isEmpty() ? 1 : 0) != 0, (String)"Cannot create namespace with invalid name: %s", (Object)namespace);
        Preconditions.checkArgument((boolean)this.isValidateNamespace(namespace), (String)"Cannot support multi part namespace in Hive Metastore: %s", (Object)namespace);
        Preconditions.checkArgument((meta.get(HMS_DB_OWNER_TYPE) == null || meta.get(HMS_DB_OWNER) != null ? 1 : 0) != 0, (String)"Create namespace setting %s without setting %s is not allowed", (Object)HMS_DB_OWNER_TYPE, (Object)HMS_DB_OWNER);
        try {
            this.clients.run(client -> {
                client.createDatabase(this.convertToDatabase(namespace, meta));
                return null;
            });
            LOG.info("Created namespace: {}", (Object)namespace);
        }
        catch (AlreadyExistsException e) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException((Throwable)e, "Namespace already exists: %s", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to create namespace " + String.valueOf(namespace) + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to createDatabase(name) " + String.valueOf(namespace) + " in Hive Metastore", e);
        }
    }

    public List<Namespace> listNamespaces(Namespace namespace) {
        if (!this.isValidateNamespace(namespace) && !namespace.isEmpty()) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        if (!namespace.isEmpty()) {
            return ImmutableList.of();
        }
        try {
            List<Namespace> namespaces = ((List)this.clients.run(IMetaStoreClient::getAllDatabases)).stream().map(xva$0 -> Namespace.of((String[])new String[]{xva$0})).collect(Collectors.toList());
            LOG.debug("Listing namespace {} returned tables: {}", (Object)namespace, namespaces);
            return namespaces;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all namespace: " + String.valueOf(namespace) + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getAllDatabases() " + String.valueOf(namespace) + " in Hive Metastore", e);
        }
    }

    public boolean dropNamespace(Namespace namespace) {
        if (!this.isValidateNamespace(namespace)) {
            return false;
        }
        try {
            this.clients.run(client -> {
                client.dropDatabase(namespace.level(0), false, false, false);
                return null;
            });
            LOG.info("Dropped namespace: {}", (Object)namespace);
            return true;
        }
        catch (InvalidOperationException e) {
            throw new NamespaceNotEmptyException((Throwable)e, "Namespace %s is not empty. One or more tables exist.", new Object[]{namespace});
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop namespace " + String.valueOf(namespace) + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to drop dropDatabase(name) " + String.valueOf(namespace) + " in Hive Metastore", e);
        }
    }

    public boolean setProperties(Namespace namespace, Map<String, String> properties) {
        Preconditions.checkArgument((properties.get(HMS_DB_OWNER_TYPE) == null == (properties.get(HMS_DB_OWNER) == null) ? 1 : 0) != 0, (String)"Setting %s and %s has to be performed together or not at all", (Object)HMS_DB_OWNER_TYPE, (Object)HMS_DB_OWNER);
        HashMap parameter = Maps.newHashMap();
        parameter.putAll(this.loadNamespaceMetadata(namespace));
        parameter.putAll(properties);
        Database database = this.convertToDatabase(namespace, parameter);
        this.alterHiveDataBase(namespace, database);
        LOG.debug("Successfully set properties {} for {}", properties.keySet(), (Object)namespace);
        return true;
    }

    public boolean removeProperties(Namespace namespace, Set<String> properties) {
        Preconditions.checkArgument((properties.contains(HMS_DB_OWNER_TYPE) == properties.contains(HMS_DB_OWNER) ? 1 : 0) != 0, (String)"Removing %s and %s has to be performed together or not at all", (Object)HMS_DB_OWNER_TYPE, (Object)HMS_DB_OWNER);
        HashMap parameter = Maps.newHashMap();
        parameter.putAll(this.loadNamespaceMetadata(namespace));
        properties.forEach(key -> parameter.put(key, null));
        Database database = this.convertToDatabase(namespace, parameter);
        this.alterHiveDataBase(namespace, database);
        LOG.debug("Successfully removed properties {} from {}", properties, (Object)namespace);
        return true;
    }

    private void alterHiveDataBase(Namespace namespace, Database database) {
        try {
            this.clients.run(client -> {
                client.alterDatabase(namespace.level(0), database);
                return null;
            });
        }
        catch (NoSuchObjectException | UnknownDBException e) {
            throw new NoSuchNamespaceException(e, "Namespace does not exist: %s", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list namespace under namespace: " + String.valueOf(namespace) + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getDatabase(name) " + String.valueOf(namespace) + " in Hive Metastore", e);
        }
    }

    public Map<String, String> loadNamespaceMetadata(Namespace namespace) {
        if (!this.isValidateNamespace(namespace)) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        try {
            Database database = (Database)this.clients.run(client -> client.getDatabase(namespace.level(0)));
            Map<String, String> metadata = this.convertToMetadata(database);
            LOG.debug("Loaded metadata for namespace {} found {}", (Object)namespace, metadata.keySet());
            return metadata;
        }
        catch (NoSuchObjectException | UnknownDBException e) {
            throw new NoSuchNamespaceException(e, "Namespace does not exist: %s", new Object[]{namespace});
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list namespace under namespace: " + String.valueOf(namespace) + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getDatabase(name) " + String.valueOf(namespace) + " in Hive Metastore", e);
        }
    }

    protected boolean isValidIdentifier(TableIdentifier tableIdentifier) {
        return tableIdentifier.namespace().levels().length == 1;
    }

    private TableIdentifier removeCatalogName(TableIdentifier to) {
        if (this.isValidIdentifier(to)) {
            return to;
        }
        if (to.namespace().levels().length == 2 && this.name().equalsIgnoreCase(to.namespace().level(0))) {
            return TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{to.namespace().level(1)}), (String)to.name());
        }
        return to;
    }

    private boolean isValidateNamespace(Namespace namespace) {
        return namespace.levels().length == 1;
    }

    public TableOperations newTableOps(TableIdentifier tableIdentifier) {
        String dbName = tableIdentifier.namespace().level(0);
        String tableName = tableIdentifier.name();
        return new HiveTableOperations(this.conf, this.clients, this.fileIO, this.name, dbName, tableName);
    }

    protected ViewOperations newViewOps(TableIdentifier identifier) {
        return new HiveViewOperations(this.conf, this.clients, this.fileIO, this.name, identifier);
    }

    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        try {
            Database databaseData = (Database)this.clients.run(client -> client.getDatabase(tableIdentifier.namespace().levels()[0]));
            if (databaseData.getLocationUri() != null) {
                return String.format("%s/%s", databaseData.getLocationUri(), tableIdentifier.name());
            }
        }
        catch (NoSuchObjectException e) {
            throw new NoSuchNamespaceException((Throwable)e, "Namespace does not exist: %s", new Object[]{tableIdentifier.namespace().levels()[0]});
        }
        catch (TException e) {
            throw new RuntimeException(String.format("Metastore operation failed for %s", tableIdentifier), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted during commit", e);
        }
        String databaseLocation = this.databaseLocation(tableIdentifier.namespace().levels()[0]);
        return String.format("%s/%s", databaseLocation, tableIdentifier.name());
    }

    private String databaseLocation(String databaseName) {
        String warehouseLocation = this.conf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname);
        Preconditions.checkNotNull((Object)warehouseLocation, (Object)"Warehouse location is not set: hive.metastore.warehouse.dir=null");
        warehouseLocation = LocationUtil.stripTrailingSlash((String)warehouseLocation);
        return String.format("%s/%s.db", warehouseLocation, databaseName);
    }

    private Map<String, String> convertToMetadata(Database database) {
        HashMap meta = Maps.newHashMap();
        meta.putAll(database.getParameters());
        meta.put("location", database.getLocationUri());
        if (database.getDescription() != null) {
            meta.put("comment", database.getDescription());
        }
        if (database.getOwnerName() != null) {
            meta.put(HMS_DB_OWNER, database.getOwnerName());
            if (database.getOwnerType() != null) {
                meta.put(HMS_DB_OWNER_TYPE, database.getOwnerType().name());
            }
        }
        return meta;
    }

    Database convertToDatabase(Namespace namespace, Map<String, String> meta) {
        if (!this.isValidateNamespace(namespace)) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        Database database = new Database();
        HashMap parameter = Maps.newHashMap();
        database.setName(namespace.level(0));
        database.setLocationUri(this.databaseLocation(namespace.level(0)));
        meta.forEach((key, value) -> {
            if (key.equals("comment")) {
                database.setDescription(value);
            } else if (key.equals("location")) {
                database.setLocationUri(value);
            } else if (key.equals(HMS_DB_OWNER)) {
                database.setOwnerName(value);
            } else if (key.equals(HMS_DB_OWNER_TYPE) && value != null) {
                database.setOwnerType(PrincipalType.valueOf((String)value));
            } else if (value != null) {
                parameter.put(key, value);
            }
        });
        if (database.getOwnerName() == null) {
            database.setOwnerName(HiveHadoopUtil.currentUser());
            database.setOwnerType(PrincipalType.USER);
        }
        database.setParameters((Map)parameter);
        return database;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("name", (Object)this.name).add("uri", (Object)(this.conf == null ? "" : this.conf.get(HiveConf.ConfVars.METASTOREURIS.varname))).toString();
    }

    public void setConf(Configuration conf) {
        this.conf = new Configuration(conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    protected Map<String, String> properties() {
        return this.catalogProperties == null ? ImmutableMap.of() : this.catalogProperties;
    }

    @VisibleForTesting
    void setListAllTables(boolean listAllTables) {
        this.listAllTables = listAllTables;
    }

    @VisibleForTesting
    ClientPool<IMetaStoreClient, TException> clientPool() {
        return this.clients;
    }

    private class TableAwareViewBuilder
    extends BaseMetastoreViewCatalog.BaseViewBuilder {
        private final TableIdentifier identifier;

        private TableAwareViewBuilder(TableIdentifier identifier) {
            super((BaseMetastoreViewCatalog)HiveCatalog.this, identifier);
            this.identifier = identifier;
        }

        public View createOrReplace() {
            if (HiveCatalog.this.tableExists(this.identifier)) {
                throw new org.apache.iceberg.exceptions.AlreadyExistsException("Table with same name already exists: %s", new Object[]{this.identifier});
            }
            return super.createOrReplace();
        }

        public View create() {
            if (HiveCatalog.this.tableExists(this.identifier)) {
                throw new org.apache.iceberg.exceptions.AlreadyExistsException("Table with same name already exists: %s", new Object[]{this.identifier});
            }
            return super.create();
        }
    }

    private class ViewAwareTableBuilder
    extends BaseMetastoreViewCatalog.BaseMetastoreViewCatalogTableBuilder {
        private final TableIdentifier identifier;

        private ViewAwareTableBuilder(TableIdentifier identifier, Schema schema) {
            super((BaseMetastoreViewCatalog)HiveCatalog.this, identifier, schema);
            this.identifier = identifier;
        }

        public Transaction createOrReplaceTransaction() {
            if (HiveCatalog.this.viewExists(this.identifier)) {
                throw new org.apache.iceberg.exceptions.AlreadyExistsException("View with same name already exists: %s", new Object[]{this.identifier});
            }
            return super.createOrReplaceTransaction();
        }

        public Table create() {
            if (HiveCatalog.this.viewExists(this.identifier)) {
                throw new org.apache.iceberg.exceptions.AlreadyExistsException("View with same name already exists: %s", new Object[]{this.identifier});
            }
            return super.create();
        }
    }
}

