/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.UnicodeUtil;

public class Comparators {
    private static final ImmutableMap<Type.PrimitiveType, Comparator<?>> COMPARATORS = ImmutableMap.builder().put((Object)Types.BooleanType.get(), Comparator.naturalOrder()).put((Object)Types.IntegerType.get(), Comparator.naturalOrder()).put((Object)Types.LongType.get(), Comparator.naturalOrder()).put((Object)Types.FloatType.get(), Comparator.naturalOrder()).put((Object)Types.DoubleType.get(), Comparator.naturalOrder()).put((Object)Types.DateType.get(), Comparator.naturalOrder()).put((Object)Types.TimeType.get(), Comparator.naturalOrder()).put((Object)Types.TimestampType.withZone(), Comparator.naturalOrder()).put((Object)Types.TimestampType.withoutZone(), Comparator.naturalOrder()).put((Object)Types.TimestampNanoType.withZone(), Comparator.naturalOrder()).put((Object)Types.TimestampNanoType.withoutZone(), Comparator.naturalOrder()).put((Object)Types.StringType.get(), Comparators.charSequences()).put((Object)Types.UUIDType.get(), Comparator.naturalOrder()).put((Object)Types.BinaryType.get(), Comparators.unsignedBytes()).buildOrThrow();

    private Comparators() {
    }

    public static Comparator<StructLike> forType(Types.StructType struct) {
        return new StructLikeComparator(struct);
    }

    public static <T> Comparator<List<T>> forType(Types.ListType list) {
        return new ListComparator(list);
    }

    public static <T> Comparator<T> forType(Type.PrimitiveType type) {
        Comparator cmp = (Comparator)COMPARATORS.get((Object)type);
        if (cmp != null) {
            return cmp;
        }
        if (type instanceof Types.FixedType) {
            return Comparators.unsignedBytes();
        }
        if (type instanceof Types.DecimalType) {
            return Comparator.naturalOrder();
        }
        throw new UnsupportedOperationException("Cannot determine comparator for type: " + String.valueOf(type));
    }

    private static <T> Comparator<T> internal(Type type) {
        if (type.isPrimitiveType()) {
            return Comparators.forType(type.asPrimitiveType());
        }
        if (type.isStructType()) {
            return Comparators.forType(type.asStructType());
        }
        if (type.isListType()) {
            return Comparators.forType(type.asListType());
        }
        throw new UnsupportedOperationException("Cannot determine comparator for type: " + String.valueOf(type));
    }

    public static Comparator<ByteBuffer> unsignedBytes() {
        return UnsignedByteBufComparator.INSTANCE;
    }

    public static Comparator<byte[]> unsignedByteArrays() {
        return UnsignedByteArrayComparator.INSTANCE;
    }

    public static Comparator<ByteBuffer> signedBytes() {
        return Comparator.naturalOrder();
    }

    public static <T> Comparator<T> nullsFirst() {
        return NullsFirst.INSTANCE;
    }

    public static <T> Comparator<T> nullsLast() {
        return NullsLast.INSTANCE;
    }

    public static Comparator<CharSequence> charSequences() {
        return CharSeqComparator.INSTANCE;
    }

    public static Comparator<CharSequence> filePath() {
        return FilePathComparator.INSTANCE;
    }

    private static class FilePathComparator
    implements Comparator<CharSequence> {
        private static final FilePathComparator INSTANCE = new FilePathComparator();

        private FilePathComparator() {
        }

        @Override
        public int compare(CharSequence s1, CharSequence s2) {
            if (s1 == s2) {
                return 0;
            }
            int count = s1.length();
            int cmp = Integer.compare(count, s2.length());
            if (cmp != 0) {
                return cmp;
            }
            if (s1 instanceof String && s2 instanceof String && (cmp = Integer.compare(s1.hashCode(), s2.hashCode())) != 0) {
                return cmp;
            }
            for (int i = count - 1; i >= 0; --i) {
                cmp = Character.compare(s1.charAt(i), s2.charAt(i));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }

    private static class CharSeqComparator
    implements Comparator<CharSequence> {
        private static final CharSeqComparator INSTANCE = new CharSeqComparator();

        private CharSeqComparator() {
        }

        @Override
        public int compare(CharSequence s1, CharSequence s2) {
            if (s1 == s2) {
                return 0;
            }
            int len = Math.min(s1.length(), s2.length());
            for (int i = 0; i < len; ++i) {
                char c1 = s1.charAt(i);
                char c2 = s2.charAt(i);
                boolean isC1HighSurrogate = UnicodeUtil.isCharHighSurrogate(c1);
                boolean isC2HighSurrogate = UnicodeUtil.isCharHighSurrogate(c2);
                if (isC1HighSurrogate && !isC2HighSurrogate) {
                    return 1;
                }
                if (!isC1HighSurrogate && isC2HighSurrogate) {
                    return -1;
                }
                int cmp = Character.compare(c1, c2);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(s1.length(), s2.length());
        }
    }

    private static class UnsignedByteArrayComparator
    implements Comparator<byte[]> {
        private static final UnsignedByteArrayComparator INSTANCE = new UnsignedByteArrayComparator();

        private UnsignedByteArrayComparator() {
        }

        @Override
        public int compare(byte[] array1, byte[] array2) {
            if (array1 == array2) {
                return 0;
            }
            int len = Math.min(array1.length, array2.length);
            for (int i = 0; i < len; ++i) {
                int cmp = Integer.compare(array1[i] & 0xFF, array2[i] & 0xFF);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(array1.length, array2.length);
        }
    }

    private static class UnsignedByteBufComparator
    implements Comparator<ByteBuffer> {
        private static final UnsignedByteBufComparator INSTANCE = new UnsignedByteBufComparator();

        private UnsignedByteBufComparator() {
        }

        @Override
        public int compare(ByteBuffer buf1, ByteBuffer buf2) {
            if (buf1 == buf2) {
                return 0;
            }
            int len = Math.min(buf1.remaining(), buf2.remaining());
            int b1pos = buf1.position();
            int b2pos = buf2.position();
            for (int i = 0; i < len; ++i) {
                int cmp = Integer.compare(buf1.get(b1pos + i) & 0xFF, buf2.get(b2pos + i) & 0xFF);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(buf1.remaining(), buf2.remaining());
        }
    }

    private static class NullSafeChainedComparator<T>
    implements Comparator<T> {
        private final Comparator<T> first;
        private final Comparator<? super T> second;

        NullSafeChainedComparator(Comparator<T> first, Comparator<? super T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == o2) {
                return 0;
            }
            int cmp = this.first.compare(o1, o2);
            if (cmp == 0 && o1 != null) {
                return this.second.compare(o1, o2);
            }
            return cmp;
        }
    }

    private static class NullsLast<T>
    implements Comparator<T> {
        private static final NullsLast<?> INSTANCE = new NullsLast();

        private NullsLast() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 != null) {
                if (o2 != null) {
                    return 0;
                }
                return -1;
            }
            return 1;
        }

        @Override
        public Comparator<T> thenComparing(Comparator<? super T> other) {
            return new NullSafeChainedComparator<T>(this, other);
        }
    }

    private static class NullsFirst<T>
    implements Comparator<T> {
        private static final NullsFirst<?> INSTANCE = new NullsFirst();

        private NullsFirst() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 != null) {
                if (o2 != null) {
                    return 0;
                }
                return 1;
            }
            return -1;
        }

        @Override
        public Comparator<T> thenComparing(Comparator<? super T> other) {
            return new NullSafeChainedComparator<T>(this, other);
        }
    }

    private static class ListComparator<T>
    implements Comparator<List<T>> {
        private final Comparator<T> elementComparator;

        private ListComparator(Types.ListType list) {
            Comparator elemComparator = Comparators.internal(list.elementType());
            this.elementComparator = list.isElementOptional() ? Comparators.nullsFirst().thenComparing(elemComparator) : elemComparator;
        }

        @Override
        public int compare(List<T> o1, List<T> o2) {
            if (o1 == o2) {
                return 0;
            }
            int length = Math.min(o1.size(), o2.size());
            for (int i = 0; i < length; ++i) {
                int cmp = this.elementComparator.compare(o1.get(i), o2.get(i));
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(o1.size(), o2.size());
        }
    }

    private static class StructLikeComparator
    implements Comparator<StructLike> {
        private final Comparator<Object>[] comparators;
        private final Class<?>[] classes;

        private StructLikeComparator(Types.StructType struct) {
            this.comparators = (Comparator[])struct.fields().stream().map(field -> field.isOptional() ? Comparators.nullsFirst().thenComparing(Comparators.internal(field.type())) : Comparators.internal(field.type())).toArray(Comparator[]::new);
            this.classes = (Class[])struct.fields().stream().map(field -> field.type().typeId().javaClass()).toArray(Class[]::new);
        }

        @Override
        public int compare(StructLike o1, StructLike o2) {
            if (o1 == o2) {
                return 0;
            }
            for (int i = 0; i < this.comparators.length; ++i) {
                Class<?> valueClass = this.classes[i];
                int cmp = this.comparators[i].compare(o1.get(i, valueClass), o2.get(i, valueClass));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

