/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.services.result.ServiceResult;
import org.apache.logging.log4j.Logger;

public class UndeployFunction
implements InternalFunction<Object[]> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private static final String ID = "org.apache.geode.management.internal.cli.functions.UndeployFunction";

    public void execute(FunctionContext<Object[]> context) {
        String memberId = "";
        try {
            List jarNamesToUndeploy;
            Object[] args = (Object[])context.getArguments();
            Object[] jarFilenameList = (String[])args[0];
            InternalCache cache = (InternalCache)context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            if (ArrayUtils.isNotEmpty((Object[])jarFilenameList)) {
                jarNamesToUndeploy = Arrays.stream(jarFilenameList).collect(Collectors.toList());
            } else {
                List jarClassLoaders = ClassPathLoader.getLatest().getJarDeploymentService().listDeployed();
                jarNamesToUndeploy = jarClassLoaders.stream().map(Deployment::getFileName).collect(Collectors.toList());
            }
            HashMap<String, String> undeployedJars = new HashMap<String, String>();
            for (String jarName : jarNamesToUndeploy) {
                ServiceResult deploymentServiceResult = ClassPathLoader.getLatest().getJarDeploymentService().undeployByFileName(jarName);
                String jarLocation = deploymentServiceResult.isSuccessful() ? ((Deployment)deploymentServiceResult.getMessage()).getFilePath() : deploymentServiceResult.getErrorMessage();
                undeployedJars.put(jarName, jarLocation);
            }
            CliFunctionResult result = new CliFunctionResult(memberId, undeployedJars, null);
            context.getResultSender().lastResult((Object)result);
        }
        catch (Exception cce) {
            logger.error(cce.getMessage(), (Throwable)cce);
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult((Object)result);
        }
    }

    public String getId() {
        return ID;
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }
}

