/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.cli.CliUtils;
import org.apache.geode.management.internal.cli.functions.GatewaySenderDestroyFunctionArgs;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.functions.CliFunctionResult;

public class GatewaySenderDestroyFunction
implements InternalFunction<GatewaySenderDestroyFunctionArgs> {
    private static final long serialVersionUID = 1L;
    @Immutable
    public static final GatewaySenderDestroyFunction INSTANCE = new GatewaySenderDestroyFunction();
    private static final String ID = "org.apache.geode.management.internal.cli.functions.GatewaySenderDestroyFunction";

    public String getId() {
        return ID;
    }

    public void execute(FunctionContext<GatewaySenderDestroyFunctionArgs> context) {
        ResultSender resultSender = context.getResultSender();
        Cache cache = context.getCache();
        String memberNameOrId = CliUtils.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember());
        GatewaySenderDestroyFunctionArgs gatewaySenderDestroyFunctionArgs = (GatewaySenderDestroyFunctionArgs)context.getArguments();
        String senderId = gatewaySenderDestroyFunctionArgs.getId();
        boolean ifExists = gatewaySenderDestroyFunctionArgs.isIfExists();
        GatewaySender gatewaySender = cache.getGatewaySender(senderId);
        if (gatewaySender == null) {
            String message = "Gateway sender " + senderId + " not found.";
            if (ifExists) {
                resultSender.lastResult((Object)new CliFunctionResult(memberNameOrId, true, "Skipping: " + message));
            } else {
                resultSender.lastResult((Object)new CliFunctionResult(memberNameOrId, false, message));
            }
            return;
        }
        try {
            gatewaySender.stop();
            gatewaySender.destroy();
            XmlEntity xmlEntity = new XmlEntity("gateway-sender", "id", senderId);
            resultSender.lastResult((Object)new CliFunctionResult(memberNameOrId, xmlEntity, String.format("GatewaySender \"%s\" destroyed on \"%s\"", senderId, memberNameOrId)));
        }
        catch (Exception e) {
            resultSender.lastResult((Object)new CliFunctionResult(memberNameOrId, (Object)e, ""));
        }
    }
}

