/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Map;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.xmlcache.CacheXmlGenerator;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class ExportConfigFunction
implements InternalFunction<Object> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private static final String ID = "org.apache.geode.management.internal.cli.functions.ExportConfigFunction";

    public String getId() {
        return ID;
    }

    public void execute(FunctionContext<Object> context) {
        String memberId = "";
        try {
            Cache cache = context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            StringWriter xmlWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(xmlWriter);
            CacheXmlGenerator.generate((Cache)cache, (PrintWriter)printWriter, (boolean)false, (boolean)false);
            printWriter.close();
            DistributionConfigImpl config = (DistributionConfigImpl)((InternalDistributedSystem)cache.getDistributedSystem()).getConfig();
            StringBuilder propStringBuf = new StringBuilder();
            String lineSeparator = System.lineSeparator();
            for (Map.Entry entry : config.getConfigPropsFromSource(ConfigSource.runtime()).entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) continue;
                propStringBuf.append(entry.getKey()).append("=").append(entry.getValue()).append(lineSeparator);
            }
            for (Map.Entry entry : config.getConfigPropsFromSource(ConfigSource.api()).entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) continue;
                propStringBuf.append(entry.getKey()).append("=").append(entry.getValue()).append(lineSeparator);
            }
            for (Map.Entry entry : config.getConfigPropsDefinedUsingFiles().entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) continue;
                propStringBuf.append(entry.getKey()).append("=").append(entry.getValue()).append(lineSeparator);
            }
            for (Map.Entry entry : config.getConfigPropsFromSource(ConfigSource.launcher()).entrySet()) {
                if (entry.getValue() == null || entry.getValue().equals("")) continue;
                propStringBuf.append(entry.getKey()).append("=").append(entry.getValue()).append(lineSeparator);
            }
            CliFunctionResult result = new CliFunctionResult(memberId, (Serializable[])new String[]{xmlWriter.toString(), propStringBuf.toString()});
            context.getResultSender().lastResult((Object)result);
        }
        catch (CacheClosedException cce) {
            CliFunctionResult result = new CliFunctionResult(memberId, false, null);
            context.getResultSender().lastResult((Object)result);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not export config {}", (Object)th.getMessage(), (Object)th);
            CliFunctionResult result = new CliFunctionResult(memberId, (Object)th, null);
            context.getResultSender().lastResult((Object)result);
        }
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }
}

