/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.Message;

public abstract class AbstractGMSMessage<ID extends MemberIdentifier>
implements Message<ID> {
    private List<ID> recipients;
    private ID sender;

    @Override
    public void registerProcessor() {
    }

    @Override
    public boolean isHighPriority() {
        return true;
    }

    @Override
    public void setRecipient(ID member) {
        this.recipients = Collections.singletonList(member);
    }

    @Override
    public void setRecipients(Collection<ID> recipients) {
        this.recipients = recipients instanceof List ? (List<Object>)recipients : new ArrayList<ID>(recipients);
    }

    @Override
    public List<ID> getRecipients() {
        if (this.getMulticast()) {
            return Collections.singletonList(ALL_RECIPIENTS);
        }
        if (this.recipients != null) {
            return this.recipients;
        }
        return Collections.singletonList(ALL_RECIPIENTS);
    }

    @Override
    public boolean forAll() {
        if (this.getMulticast()) {
            return true;
        }
        List<ID> recipients = this.getRecipients();
        return recipients == ALL_RECIPIENTS || recipients.size() == 1 && recipients.get(0) == ALL_RECIPIENTS;
    }

    @Override
    public void setSender(ID sender) {
        this.sender = sender;
    }

    @Override
    public ID getSender() {
        return this.sender;
    }

    String getShortClassName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public long resetTimestamp() {
        return 0L;
    }

    @Override
    public int getBytesRead() {
        return 0;
    }

    @Override
    public void setBytesRead(int amount) {
    }
}

