/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.cache.query.cq.internal.ServerCQResultsCache;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

class ServerCQResultsCachePartitionRegionImpl
implements ServerCQResultsCache {
    private static final Logger logger = LogService.getLogger();
    public volatile boolean cqResultKeysInitialized = false;
    private final ConcurrentMap<Object, Object> cqResultKeys = new ConcurrentHashMap<Object, Object>();

    @Override
    public void setInitialized() {
        this.cqResultKeysInitialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.cqResultKeysInitialized;
    }

    @Override
    public void add(Object key) {
        this.cqResultKeys.put(key, TOKEN);
    }

    @Override
    public void remove(Object key, boolean isTokenMode) {
        if (isTokenMode && this.cqResultKeys.get(key) != Token.DESTROYED) {
            return;
        }
        this.cqResultKeys.remove(key);
    }

    @Override
    public void invalidate() {
        this.cqResultKeys.clear();
        this.cqResultKeysInitialized = false;
    }

    @Override
    public boolean contains(Object key) {
        if (!this.isInitialized()) {
            logger.warn("The CQ Result key cache is not initialized. This should not happen as the call to isPartOfCqResult() is based on the condition cqResultsCacheInitialized.");
            return false;
        }
        return this.cqResultKeys.containsKey(key);
    }

    @Override
    public void markAsDestroyed(Object key) {
        this.cqResultKeys.put(key, Token.DESTROYED);
    }

    @Override
    public int size() {
        return this.cqResultKeys.size();
    }

    @Override
    public Set<Object> getKeys() {
        return Collections.synchronizedSet(new HashSet(this.cqResultKeys.keySet()));
    }

    @Override
    public boolean isOldValueRequiredForQueryProcessing(Object key) {
        return !this.isInitialized() || !this.contains(key);
    }

    @Override
    public boolean isKeyDestroyed(Object key) {
        return this.cqResultKeys.get(key) == Token.DESTROYED;
    }

    @Override
    public void clear() {
        this.cqResultKeys.clear();
    }
}

