/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.beans.stats.IntegerStatsDeltaAggregator;
import org.apache.geode.management.internal.beans.stats.StatsAggregator;

public class MemberClusterStatsMonitor {
    private static final String SYSTEM_DISK_STORE_COUNT = "DiskStores";
    private static final String DISK_READS_RATE = "DiskReadsRate";
    private static final String DISK_WRITES_RATE = "DiskWritesRate";
    private static final String DISK_FLUSH_AVG_LATENCY = "DiskFlushAvgLatency";
    private static final String TOTAL_BACKUP_IN_PROGRESS = "TotalBackupInProgress";
    private static final String TOTAL_HIT_COUNT = "TotalHitCount";
    private static final String TOTAL_MISS_COUNT = "TotalMissCount";
    private static final String NUM_INITIAL_IMAGE_IN_PROGRESSS = "numInitialImagesInProgress";
    private static final String TOTAL_DISK_USAGE = "TotalDiskUsage";
    private static final String NUM_RUNNING_FUNCTIONS = "NumRunningFunctions";
    private static final String AVERAGE_READS = "AverageReads";
    private static final String AVERAGE_WRITES = "AverageWrites";
    private static final String GARBAGE_COLL_COUNT = "GarbageCollectionCount";
    private static final String JVM_PAUSES = "JVMPauses";
    private static final String OFF_HEAP_MAX_MEMORY = "OffHeapMaxMemory";
    private static final String OFF_HEAP_USED_MEMORY = "OffHeapUsedMemory";
    private static final String OFF_HEAP_FREE_MEMORY = "OffHeapFreeMemory";
    private static final String TXN_COMMITTED_TOTAL_COUNT = "TransactionCommittedTotalCount";
    private static final String TXN_ROLLEDBACK_TOTAL_COUNT = "TransactionRolledBackTotalCount";
    private static final String MAX_MEMORY = "MaxMemory";
    private static final String USED_MEMORY = "UsedMemory";
    private static final String FREE_MEMORY = "FreeMemory";
    private final AtomicInteger systemDiskStoreCount = new AtomicInteger(0);
    private final StatsAggregator aggregator;
    private final IntegerStatsDeltaAggregator deltas;
    private final Map<String, Class<?>> typeMap = new HashMap();

    public void aggregate(FederationComponent newState, FederationComponent oldState) {
        this.aggregator.aggregate(newState, oldState);
        this.incSystemDiskStoreCount(newState, oldState);
        this.deltas.aggregate(newState, oldState);
    }

    public MemberClusterStatsMonitor() {
        this.intTypeMap();
        this.aggregator = new StatsAggregator(this.typeMap);
        ArrayList<String> keysList = new ArrayList<String>();
        keysList.add(TXN_COMMITTED_TOTAL_COUNT);
        keysList.add(TXN_ROLLEDBACK_TOTAL_COUNT);
        this.deltas = new IntegerStatsDeltaAggregator(keysList);
    }

    private void intTypeMap() {
        this.typeMap.put(DISK_FLUSH_AVG_LATENCY, Long.TYPE);
        this.typeMap.put(DISK_READS_RATE, Float.TYPE);
        this.typeMap.put(DISK_WRITES_RATE, Float.TYPE);
        this.typeMap.put(TOTAL_BACKUP_IN_PROGRESS, Integer.TYPE);
        this.typeMap.put(TOTAL_HIT_COUNT, Integer.TYPE);
        this.typeMap.put(TOTAL_MISS_COUNT, Integer.TYPE);
        this.typeMap.put(NUM_INITIAL_IMAGE_IN_PROGRESSS, Integer.TYPE);
        this.typeMap.put(TOTAL_DISK_USAGE, Long.TYPE);
        this.typeMap.put(NUM_RUNNING_FUNCTIONS, Integer.TYPE);
        this.typeMap.put(AVERAGE_READS, Float.TYPE);
        this.typeMap.put(AVERAGE_WRITES, Float.TYPE);
        this.typeMap.put(GARBAGE_COLL_COUNT, Long.TYPE);
        this.typeMap.put(JVM_PAUSES, Long.TYPE);
        this.typeMap.put(MAX_MEMORY, Long.TYPE);
        this.typeMap.put(USED_MEMORY, Long.TYPE);
        this.typeMap.put(FREE_MEMORY, Long.TYPE);
        this.typeMap.put(OFF_HEAP_MAX_MEMORY, Long.TYPE);
        this.typeMap.put(OFF_HEAP_USED_MEMORY, Long.TYPE);
        this.typeMap.put(OFF_HEAP_FREE_MEMORY, Long.TYPE);
    }

    public float getDiskReadsRate() {
        return this.aggregator.getFloatValue(DISK_READS_RATE).floatValue();
    }

    public float getDiskWritesRate() {
        return this.aggregator.getFloatValue(DISK_WRITES_RATE).floatValue();
    }

    public long getDiskFlushAvgLatency() {
        return this.aggregator.getLongValue(DISK_FLUSH_AVG_LATENCY);
    }

    public int getSystemDiskStoreCount() {
        return this.systemDiskStoreCount.get();
    }

    public int getTotalBackupInProgress() {
        return this.aggregator.getIntValue(TOTAL_BACKUP_IN_PROGRESS);
    }

    public long getTotalHeapSize() {
        return this.getMaxMemory();
    }

    public int getTotalHitCount() {
        return this.aggregator.getIntValue(TOTAL_HIT_COUNT);
    }

    public int getTotalMissCount() {
        return this.aggregator.getIntValue(TOTAL_MISS_COUNT);
    }

    public int getNumInitialImagesInProgress() {
        return this.aggregator.getIntValue(NUM_INITIAL_IMAGE_IN_PROGRESSS);
    }

    public void incSystemDiskStoreCount(FederationComponent newState, FederationComponent oldState) {
        String[] diskStores;
        if (oldState != null && oldState.getValue(SYSTEM_DISK_STORE_COUNT) != null && (diskStores = (String[])oldState.getValue(SYSTEM_DISK_STORE_COUNT)) != null) {
            this.systemDiskStoreCount.addAndGet(-diskStores.length);
        }
        if (newState != null && newState.getValue(SYSTEM_DISK_STORE_COUNT) != null && (diskStores = (String[])newState.getValue(SYSTEM_DISK_STORE_COUNT)) != null) {
            this.systemDiskStoreCount.addAndGet(diskStores.length);
        }
    }

    public int getNumRunningFunctions() {
        return this.aggregator.getIntValue(NUM_RUNNING_FUNCTIONS);
    }

    public long getTotalDiskUsage() {
        return this.aggregator.getLongValue(TOTAL_DISK_USAGE);
    }

    public float getAverageReads() {
        return this.aggregator.getFloatValue(AVERAGE_READS).floatValue();
    }

    public float getAverageWrites() {
        return this.aggregator.getFloatValue(AVERAGE_WRITES).floatValue();
    }

    public long getUsedHeapSize() {
        return this.getUsedMemory();
    }

    public long getGarbageCollectionCount() {
        return this.aggregator.getLongValue(GARBAGE_COLL_COUNT);
    }

    public long getJVMPauses() {
        return this.aggregator.getLongValue(JVM_PAUSES);
    }

    public long getOffHeapFreeMemory() {
        return this.aggregator.getLongValue(OFF_HEAP_FREE_MEMORY);
    }

    public long getOffHeapUsedMemory() {
        return this.aggregator.getLongValue(OFF_HEAP_USED_MEMORY);
    }

    public int getTransactionCommitted() {
        return this.deltas.getDelta(TXN_COMMITTED_TOTAL_COUNT);
    }

    public int getTransactionRolledBack() {
        return this.deltas.getDelta(TXN_ROLLEDBACK_TOTAL_COUNT);
    }

    public long getMaxMemory() {
        return this.aggregator.getLongValue(MAX_MEMORY);
    }

    public long getFreeMemory() {
        return this.aggregator.getLongValue(FREE_MEMORY);
    }

    public long getUsedMemory() {
        return this.aggregator.getLongValue(USED_MEMORY);
    }
}

