/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.util.List;
import org.apache.geode.Statistics;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.GatewaySenderEventDispatcher;
import org.apache.geode.internal.cache.wan.GatewaySenderStats;
import org.apache.geode.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.parallel.ParallelGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.serial.ConcurrentSerialGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.serial.SerialGatewaySenderEventProcessor;
import org.apache.geode.management.internal.beans.stats.GatewaySenderOverflowMonitor;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;
import org.apache.geode.management.internal.beans.stats.StatType;
import org.apache.geode.management.internal.beans.stats.StatsAverageLatency;
import org.apache.geode.management.internal.beans.stats.StatsRate;

public class GatewaySenderMBeanBridge {
    private final GatewaySender sender;
    private final MBeanStatsMonitor monitor;
    private final GatewaySenderOverflowMonitor overflowMonitor;
    private StatsRate eventsQueuedRate;
    private StatsRate eventsReceivedRate;
    private StatsRate batchesDispatchedRate;
    private StatsRate lruEvictionsRate;
    private StatsAverageLatency batchDistributionAvgLatency;
    private GatewaySenderEventDispatcher dispatcher;
    private final AbstractGatewaySender abstractSender;

    public GatewaySenderMBeanBridge(GatewaySender sender) {
        this.sender = sender;
        this.monitor = new MBeanStatsMonitor("GatewaySenderMXBeanMonitor");
        this.overflowMonitor = new GatewaySenderOverflowMonitor("GatewaySenderMXBeanOverflowMonitor");
        this.abstractSender = (AbstractGatewaySender)this.sender;
        GatewaySenderStats stats = this.abstractSender.getStatistics();
        this.addGatewaySenderStats(stats);
        this.initializeStats();
    }

    public void setDispatcher() {
        AbstractGatewaySenderEventProcessor eventProcessor = this.abstractSender.getEventProcessor();
        if (eventProcessor != null) {
            this.dispatcher = this.abstractSender.getEventProcessor().getDispatcher();
        }
    }

    public void addGatewaySenderStats(GatewaySenderStats gatewaySenderStats) {
        this.monitor.addStatisticsToMonitor(gatewaySenderStats.getStats());
    }

    public void addOverflowStatistics(Statistics statistics) {
        if (statistics != null) {
            this.overflowMonitor.addStatisticsToMonitor(statistics);
        }
    }

    public void clearOverflowStatistics() {
        this.overflowMonitor.stopListener();
        this.overflowMonitor.clearCounters();
    }

    public void stopMonitor() {
        this.monitor.stopListener();
    }

    private void initializeStats() {
        this.eventsQueuedRate = new StatsRate("eventsQueued", StatType.INT_TYPE, this.monitor);
        this.eventsReceivedRate = new StatsRate("eventsReceived", StatType.INT_TYPE, this.monitor);
        this.batchesDispatchedRate = new StatsRate("batchesDistributed", StatType.INT_TYPE, this.monitor);
        this.batchDistributionAvgLatency = new StatsAverageLatency("batchesDistributed", StatType.INT_TYPE, "batchDistributionTime", this.monitor);
        this.lruEvictionsRate = new StatsRate("lruEvictions", StatType.LONG_TYPE, (MBeanStatsMonitor)this.overflowMonitor);
    }

    public int getAlertThreshold() {
        return this.sender.getAlertThreshold();
    }

    public int getBatchSize() {
        return this.sender.getBatchSize();
    }

    public long getBatchTimeInterval() {
        return this.sender.getBatchTimeInterval();
    }

    public String getOverflowDiskStoreName() {
        return this.sender.getDiskStoreName();
    }

    public String[] getGatewayEventFilters() {
        List<GatewayEventFilter> filters = this.sender.getGatewayEventFilters();
        String[] filtersStr = null;
        if (filters == null || filters.size() <= 0) {
            return filtersStr;
        }
        filtersStr = new String[filters.size()];
        int j = 0;
        for (GatewayEventFilter filter : filters) {
            filtersStr[j] = filter.toString();
            ++j;
        }
        return filtersStr;
    }

    public String[] getGatewayTransportFilters() {
        List<GatewayTransportFilter> transportFilters = this.sender.getGatewayTransportFilters();
        String[] transportFiltersStr = null;
        if (transportFilters == null || transportFilters.size() <= 0) {
            return transportFiltersStr;
        }
        transportFiltersStr = new String[transportFilters.size()];
        int j = 0;
        for (GatewayTransportFilter listener : transportFilters) {
            transportFiltersStr[j] = listener.getClass().getCanonicalName();
            ++j;
        }
        return transportFiltersStr;
    }

    public int getMaximumQueueMemory() {
        return this.sender.getMaximumQueueMemory();
    }

    public int getRemoteDSId() {
        return this.sender.getRemoteDSId();
    }

    public String getSenderId() {
        return this.sender.getId();
    }

    public int getSocketBufferSize() {
        return this.sender.getSocketBufferSize();
    }

    public long getSocketReadTimeout() {
        return this.sender.getSocketReadTimeout();
    }

    public boolean isBatchConflationEnabled() {
        return this.sender.isBatchConflationEnabled();
    }

    public boolean isManualStart() {
        return this.sender.isManualStart();
    }

    public boolean isPaused() {
        return this.sender.isPaused();
    }

    public boolean isPersistenceEnabled() {
        return this.sender.isPersistenceEnabled();
    }

    public boolean isRunning() {
        return this.sender.isRunning();
    }

    public void pause() {
        this.sender.pause();
    }

    public void resume() {
        this.sender.resume();
    }

    public void start() {
        this.sender.start();
    }

    public void startWithCleanQueue() {
        this.sender.startWithCleanQueue();
    }

    public void stop() {
        this.sender.stop();
    }

    public void rebalance() {
        this.sender.rebalance();
    }

    public boolean isPrimary() {
        return ((AbstractGatewaySender)this.sender).isPrimary();
    }

    public int getDispatcherThreads() {
        return this.sender.getDispatcherThreads();
    }

    public String getOrderPolicy() {
        return this.sender.getOrderPolicy() != null ? this.sender.getOrderPolicy().name() : null;
    }

    public boolean isDiskSynchronous() {
        return this.sender.isDiskSynchronous();
    }

    public boolean isParallel() {
        return this.sender.isParallel();
    }

    public boolean mustGroupTransactionEvents() {
        return this.sender.mustGroupTransactionEvents();
    }

    public int getTotalBatchesDistributed() {
        return this.getStatistic("batchesDistributed").intValue();
    }

    public int getTotalBatchesRedistributed() {
        return this.getStatistic("batchesRedistributed").intValue();
    }

    public int getTotalBatchesWithIncompleteTransactions() {
        return this.getStatistic("batchesWithIncompleteTransactions").intValue();
    }

    public int getTotalEventsConflated() {
        return this.getStatistic("eventsNotQueuedConflated").intValue();
    }

    public int getEventQueueSize() {
        return this.abstractSender.getEventQueueSize();
    }

    public float getEventsQueuedRate() {
        return this.eventsQueuedRate.getRate();
    }

    public float getEventsReceivedRate() {
        return this.eventsReceivedRate.getRate();
    }

    public float getBatchesDispatchedRate() {
        return this.batchesDispatchedRate.getRate();
    }

    public long getAverageDistributionTimePerBatch() {
        return this.batchDistributionAvgLatency.getAverageLatency();
    }

    public float getLRUEvictionsRate() {
        return this.lruEvictionsRate.getRate();
    }

    public long getEntriesOverflowedToDisk() {
        return this.overflowMonitor.getStatistic("entriesOnlyOnDisk").longValue();
    }

    public long getBytesOverflowedToDisk() {
        return this.overflowMonitor.getStatistic("bytesOnlyOnDisk").longValue();
    }

    public long getTotalQueueSizeBytesInUse() {
        return this.overflowMonitor.getStatistic("byteCount").longValue();
    }

    private Number getStatistic(String statName) {
        if (this.monitor != null) {
            return this.monitor.getStatistic(statName);
        }
        return 0;
    }

    public String getGatewayReceiver() {
        return ((AbstractGatewaySender)this.sender).getServerLocation().toString();
    }

    public boolean isConnected() {
        if (this.dispatcher != null && this.dispatcher.isConnectedToRemote()) {
            return true;
        }
        if (this.sender.isParallel()) {
            ConcurrentParallelGatewaySenderEventProcessor cProc = (ConcurrentParallelGatewaySenderEventProcessor)((AbstractGatewaySender)this.sender).getEventProcessor();
            for (ParallelGatewaySenderEventProcessor lProc : cProc.getProcessors()) {
                if (lProc.getDispatcher() == null || !lProc.getDispatcher().isConnectedToRemote()) continue;
                this.dispatcher = lProc.getDispatcher();
                return true;
            }
        } else if (this.getDispatcherThreads() > 1) {
            ConcurrentSerialGatewaySenderEventProcessor cProc = (ConcurrentSerialGatewaySenderEventProcessor)((AbstractGatewaySender)this.sender).getEventProcessor();
            for (SerialGatewaySenderEventProcessor lProc : cProc.getProcessors()) {
                if (lProc.getDispatcher() == null || !lProc.getDispatcher().isConnectedToRemote()) continue;
                this.dispatcher = lProc.getDispatcher();
                return true;
            }
        } else {
            SerialGatewaySenderEventProcessor lProc = (SerialGatewaySenderEventProcessor)((AbstractGatewaySender)this.sender).getEventProcessor();
            if (lProc.getDispatcher() != null && lProc.getDispatcher().isConnectedToRemote()) {
                this.dispatcher = lProc.getDispatcher();
                return true;
            }
        }
        return false;
    }

    public int getEventsExceedingAlertThreshold() {
        return this.getStatistic("eventsExceedingAlertThreshold").intValue();
    }
}

