/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.geode.LogWriter;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.ManagementResourceRepo;
import org.apache.geode.management.internal.NotificationKey;

public class NotificationHub {
    private final LogWriter logger;
    protected ManagementResourceRepo repo;
    private final MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;
    private final Map<ObjectName, NotificationHubListener> listenerObjectMap;
    private final String memberSource;

    public NotificationHub(ManagementResourceRepo repo) {
        this.repo = repo;
        this.logger = InternalDistributedSystem.getLogger();
        this.listenerObjectMap = new HashMap<ObjectName, NotificationHubListener>();
        this.memberSource = MBeanJMXAdapter.getMemberNameOrUniqueId(InternalDistributedSystem.getConnectedInstance().getDistributedMember());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHubNotificationListener(String memberName, ObjectName objectName) {
        try {
            Map<ObjectName, NotificationHubListener> map = this.listenerObjectMap;
            synchronized (map) {
                NotificationHubListener listener = this.listenerObjectMap.get(objectName);
                if (listener == null) {
                    listener = new NotificationHubListener(objectName);
                    listener.incNumCounter();
                    this.mbeanServer.addNotificationListener(objectName, listener, null, null);
                    this.listenerObjectMap.put(objectName, listener);
                } else {
                    listener.incNumCounter();
                }
            }
        }
        catch (InstanceNotFoundException e) {
            throw new ManagementException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHubNotificationListener(String memberName, ObjectName objectName) {
        try {
            Map<ObjectName, NotificationHubListener> map = this.listenerObjectMap;
            synchronized (map) {
                NotificationHubListener listener;
                if (this.listenerObjectMap.get(objectName) != null && (listener = this.listenerObjectMap.get(objectName)).decNumCounter() == 0) {
                    this.listenerObjectMap.remove(objectName);
                    this.mbeanServer.removeNotificationListener(objectName, listener);
                }
            }
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpListeners() {
        Map<ObjectName, NotificationHubListener> map = this.listenerObjectMap;
        synchronized (map) {
            for (ObjectName objectName : this.listenerObjectMap.keySet()) {
                NotificationHubListener listener = this.listenerObjectMap.get(objectName);
                if (listener == null) continue;
                try {
                    this.mbeanServer.removeNotificationListener(objectName, listener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                }
                catch (InstanceNotFoundException instanceNotFoundException) {}
            }
        }
        this.listenerObjectMap.clear();
    }

    public Map<ObjectName, NotificationHubListener> getListenerObjectMap() {
        return this.listenerObjectMap;
    }

    public class NotificationHubListener
    implements NotificationListener {
        private final ObjectName name;
        private int numCounter = 0;

        protected NotificationHubListener(ObjectName name) {
            this.name = name;
        }

        public int incNumCounter() {
            return ++this.numCounter;
        }

        public int decNumCounter() {
            return --this.numCounter;
        }

        public int getNumCounter() {
            return this.numCounter;
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            NotificationKey key = new NotificationKey(this.name);
            notification.setUserData(NotificationHub.this.memberSource);
            NotificationHub.this.repo.putEntryInLocalNotificationRegion(key, notification);
        }
    }
}

