/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ClassLoadUtils;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.MBeanProxyInfoRepository;
import org.apache.geode.management.internal.MBeanProxyInvocationHandler;
import org.apache.geode.management.internal.ProxyInfo;
import org.apache.geode.management.internal.ProxyInterface;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;

public class MBeanProxyFactory {
    private static final Logger logger = LogService.getLogger();
    private final MBeanProxyInfoRepository proxyRepo;
    private final MBeanJMXAdapter jmxAdapter;
    private final SystemManagementService service;

    public MBeanProxyFactory(MBeanJMXAdapter jmxAdapter, SystemManagementService service) {
        this.jmxAdapter = jmxAdapter;
        this.service = service;
        this.proxyRepo = new MBeanProxyInfoRepository();
    }

    void createProxy(DistributedMember member, ObjectName objectName, Region<String, Object> monitoringRegion, Object newValue) {
        try {
            FederationComponent federation = (FederationComponent)newValue;
            String interfaceClassName = federation.getMBeanInterfaceClass();
            Class interfaceClass = ClassLoadUtils.classFromName(interfaceClassName);
            Object proxy = MBeanProxyInvocationHandler.newProxyInstance(member, monitoringRegion, objectName, federation, interfaceClass);
            this.jmxAdapter.registerMBeanProxy(proxy, objectName);
            if (logger.isDebugEnabled()) {
                logger.debug("Registered ObjectName : {}", (Object)objectName);
            }
            ProxyInfo proxyInfo = new ProxyInfo(interfaceClass, proxy, objectName);
            this.proxyRepo.addProxyToRepository(member, proxyInfo);
            this.service.afterCreateProxy(objectName, interfaceClass, proxy, (FederationComponent)newValue);
            if (logger.isDebugEnabled()) {
                logger.debug("Proxy Created for : {}", (Object)objectName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ManagementException(e);
        }
    }

    void createAllProxies(DistributedMember member, Region<String, Object> monitoringRegion) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating proxy for: {}", (Object)member.getId());
        }
        Set<Map.Entry<String, Object>> mbeans = monitoringRegion.entrySet();
        for (Map.Entry<String, Object> mbean : mbeans) {
            try {
                ObjectName objectName = ObjectName.getInstance(mbean.getKey());
                if (logger.isDebugEnabled()) {
                    logger.debug("Creating proxy for ObjectName {}", (Object)objectName);
                }
                this.createProxy(member, objectName, monitoringRegion, mbean.getValue());
            }
            catch (Exception e) {
                logger.warn("Create Proxy failed for {} with exception {}", (Object)mbean.getKey(), (Object)e.getMessage(), (Object)e);
            }
        }
    }

    void removeAllProxies(DistributedMember member, Region<String, Object> monitoringRegion) {
        Set<Map.Entry<String, Object>> entries = monitoringRegion.entrySet();
        if (logger.isDebugEnabled()) {
            logger.debug("Removing {} proxies for member {}", (Object)entries.size(), (Object)member.getId());
        }
        for (Map.Entry<String, Object> entry : entries) {
            String key = null;
            try {
                key = entry.getKey();
                Object federation = entry.getValue();
                ObjectName mbeanName = ObjectName.getInstance(key);
                this.removeProxy(member, mbeanName, federation);
            }
            catch (EntryNotFoundException entryNotFoundException) {
                this.logProxyAlreadyRemoved(member, entry);
            }
            catch (Exception e) {
                if (e.getCause() instanceof InstanceNotFoundException) continue;
                logger.warn("Remove Proxy failed for {} due to {}", (Object)key, (Object)e.getMessage(), (Object)e);
            }
        }
    }

    void removeProxy(DistributedMember member, ObjectName objectName, Object oldValue) {
        block5: {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing proxy for ObjectName {}", (Object)objectName);
                }
                ProxyInfo proxyInfo = this.proxyRepo.findProxyInfo(objectName);
                this.proxyRepo.removeProxy(member, objectName);
                if (proxyInfo != null) {
                    this.service.afterRemoveProxy(objectName, proxyInfo.getProxyInterface(), proxyInfo.getProxyInstance(), (FederationComponent)oldValue);
                }
                this.jmxAdapter.unregisterMBean(objectName);
                if (logger.isDebugEnabled()) {
                    logger.debug("Removed proxy for ObjectName {}", (Object)objectName);
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof InstanceNotFoundException) break block5;
                logger.warn("Could not remove proxy for Member {} due to {}", (Object)member, (Object)e.getMessage(), (Object)e);
            }
        }
    }

    void updateProxy(ObjectName objectName, ProxyInfo proxyInfo, Object newObject, Object oldObject) {
        try {
            if (proxyInfo != null) {
                Class interfaceClass = proxyInfo.getProxyInterface();
                this.service.afterUpdateProxy(objectName, interfaceClass, proxyInfo.getProxyInstance(), (FederationComponent)newObject, (FederationComponent)oldObject);
            }
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
    }

    <T> T findProxy(ObjectName objectName, Class<T> interfaceClass) {
        return this.proxyRepo.findProxyByName(objectName, interfaceClass);
    }

    ProxyInfo findProxyInfo(ObjectName objectName) {
        return this.proxyRepo.findProxyInfo(objectName);
    }

    public Set<ObjectName> findAllProxies(DistributedMember member) {
        return this.proxyRepo.findProxySet(member);
    }

    long getLastUpdateTime(ObjectName objectName) {
        ProxyInterface proxyInterface = this.findProxy(objectName, ProxyInterface.class);
        return proxyInterface.getLastRefreshedTime();
    }

    @VisibleForTesting
    void logProxyAlreadyRemoved(DistributedMember member, Map.Entry<String, Object> entry) {
        logger.warn("Proxy for entry {} and member {} has already been removed", entry, (Object)member.getId());
    }
}

