/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.lang;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class SystemUtils {
    public static final String CURRENT_DIRECTORY = System.getProperty("user.dir");
    public static final String IBM_J9_JVM_NAME = "J9";
    public static final String JAVA_HOTSPOT_JVM_NAME = "HotSpot";
    public static final String ORACLE_JROCKIT_JVM_NAME = "JRockit";
    public static final String APPLE_JVM_VENDOR_NAME = "Apple";
    public static final String IBM_JVM_NAME = "IBM";
    public static final String ORACLE_JVM_VENDOR_NAME = "Oracle";
    public static final String AZUL_JVM_VENDOR_NAME = "Azul";
    public static final String LINUX_OS_NAME = "Linux";
    public static final String MAC_OSX_NAME = "Mac";
    public static final String WINDOWS_OS_NAME = "Windows";
    public static final String SOLARIS_OS_NAME = "SunOS";

    public static boolean isAppleJVM() {
        return SystemUtils.isJvmVendor(APPLE_JVM_VENDOR_NAME);
    }

    public static boolean isOracleJVM() {
        return SystemUtils.isJvmVendor(ORACLE_JVM_VENDOR_NAME);
    }

    public static boolean isAzulJVM() {
        return SystemUtils.isJvmVendor(AZUL_JVM_VENDOR_NAME);
    }

    private static boolean isJvmVendor(String expectedJvmVendorName) {
        String jvmVendor = System.getProperty("java.vm.vendor");
        return jvmVendor != null && jvmVendor.contains(expectedJvmVendorName);
    }

    public static boolean isHotSpotVM() {
        return SystemUtils.isJVM(JAVA_HOTSPOT_JVM_NAME);
    }

    public static boolean isJ9VM() {
        return SystemUtils.isJVM(IBM_J9_JVM_NAME);
    }

    public static boolean isJRockitVM() {
        return SystemUtils.isJVM(ORACLE_JROCKIT_JVM_NAME);
    }

    private static boolean isJVM(String expectedJvmName) {
        String jvmName = System.getProperty("java.vm.name");
        return jvmName != null && jvmName.contains(expectedJvmName);
    }

    public static boolean isLinux() {
        return SystemUtils.isOS(LINUX_OS_NAME);
    }

    public static boolean isMacOSX() {
        return SystemUtils.isOS(MAC_OSX_NAME);
    }

    public static boolean isWindows() {
        return SystemUtils.isOS(WINDOWS_OS_NAME);
    }

    public static boolean isSolaris() {
        return SystemUtils.isOS(SOLARIS_OS_NAME);
    }

    public static boolean isInClassPath(String location) throws MalformedURLException {
        return SystemUtils.isInClassPath(new File(location).toURI().toURL());
    }

    public static boolean isInClassPath(URL location) throws MalformedURLException {
        String classPath = SystemUtils.getClassPath();
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            if (!location.equals(new File(path).toURI().toURL())) continue;
            return true;
        }
        return false;
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static String getOsArchitecture() {
        return System.getProperty("os.arch");
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public static String getBootClassPath() {
        return System.getProperty("sun.boot.class.path");
    }

    private static boolean isOS(String expectedOsName) {
        String osName = SystemUtils.getOsName();
        return osName != null && osName.contains(expectedOsName);
    }
}

