/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.util.OptionalLong;
import java.util.Random;
import java.util.function.Consumer;
import org.apache.geode.internal.cache.tier.sockets.SubjectIdGenerator;

public class RandomSubjectIdGenerator
implements SubjectIdGenerator {
    private final Random random;
    private final Consumer<Random> initializer;
    private long firstIdInCurrentSequence;
    private boolean mustStartNewSequence = true;

    public RandomSubjectIdGenerator(Random random, Consumer<Random> randomInitializer) {
        this.random = random;
        this.initializer = randomInitializer;
    }

    @Override
    public OptionalLong generateId() {
        long id;
        if (this.mustStartNewSequence) {
            this.initializer.accept(this.random);
        }
        if ((id = this.random.nextLong()) == this.firstIdInCurrentSequence) {
            this.mustStartNewSequence = true;
            return OptionalLong.empty();
        }
        if (this.mustStartNewSequence) {
            this.firstIdInCurrentSequence = id;
            this.mustStartNewSequence = false;
        }
        return OptionalLong.of(id);
    }
}

