/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence.query.mock;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.geode.cache.query.internal.types.ExtendedNumericComparator;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.PreferBytesCachedDeserializable;
import org.apache.geode.internal.cache.persistence.query.CloseableIterator;
import org.apache.geode.internal.cache.persistence.query.IndexMap;
import org.apache.geode.internal.cache.persistence.query.mock.ByteComparator;
import org.apache.geode.internal.cache.persistence.query.mock.CachedDeserializableComparator;
import org.apache.geode.internal.cache.persistence.query.mock.ItrAdapter;
import org.apache.geode.internal.cache.persistence.query.mock.Pair;
import org.apache.geode.internal.cache.persistence.query.mock.PairComparator;

public class IndexMapImpl
implements IndexMap {
    ConcurrentSkipListMap<Pair<CachedDeserializable, CachedDeserializable>, CachedDeserializable> map = new ConcurrentSkipListMap(new PairComparator(new CachedDeserializableComparator(new ExtendedNumericComparator()), new ByteComparator()));

    @Override
    public void put(Object indexKey, Object regionKey, Object value) {
        this.map.put(new Pair<CachedDeserializable, CachedDeserializable>(this.toDeserializable(indexKey), this.toDeserializable(regionKey)), this.toDeserializable(value));
    }

    @Override
    public void remove(Object indexKey, Object regionKey) {
        this.map.remove(new Pair<Object, byte[]>(indexKey, EntryEventImpl.serialize(regionKey)));
    }

    @Override
    public CloseableIterator<IndexMap.IndexEntry> get(Object indexKey) {
        return new Itr(this.map.subMap(new Pair<Object, byte[]>(indexKey, ByteComparator.MIN_BYTES), true, new Pair<Object, byte[]>(indexKey, ByteComparator.MAX_BYTES), true).entrySet().iterator());
    }

    @Override
    public CloseableIterator<CachedDeserializable> getKey(Object indexKey) {
        return new KeyItr(this.map.subMap(new Pair<Object, byte[]>(indexKey, ByteComparator.MIN_BYTES), true, new Pair<Object, byte[]>(indexKey, ByteComparator.MAX_BYTES), true).entrySet().iterator());
    }

    @Override
    public CloseableIterator<IndexMap.IndexEntry> iterator(Object start, boolean startInclusive, Object end, boolean endInclusive) {
        byte[] startBytes = startInclusive ? ByteComparator.MIN_BYTES : ByteComparator.MAX_BYTES;
        byte[] endBytes = endInclusive ? ByteComparator.MAX_BYTES : ByteComparator.MIN_BYTES;
        return new Itr(this.map.subMap(new Pair<Object, byte[]>(start, startBytes), startInclusive, new Pair<Object, byte[]>(end, endBytes), endInclusive).entrySet().iterator());
    }

    @Override
    public CloseableIterator<IndexMap.IndexEntry> iterator(Object start, boolean startInclusive) {
        byte[] startBytes = startInclusive ? ByteComparator.MIN_BYTES : ByteComparator.MAX_BYTES;
        return new Itr(this.map.tailMap(new Pair<Object, byte[]>(start, startBytes), startInclusive).entrySet().iterator());
    }

    @Override
    public CloseableIterator<IndexMap.IndexEntry> iterator() {
        return new Itr(this.map.entrySet().iterator());
    }

    public CloseableIterator<CachedDeserializable> valueIterator() {
        return new ItrAdapter(this.map.values().iterator());
    }

    public CloseableIterator<CachedDeserializable> descendingValueIterator() {
        return new ItrAdapter(this.map.descendingMap().values().iterator());
    }

    @Override
    public CloseableIterator<IndexMap.IndexEntry> descendingIterator(Object end, boolean endInclusive) {
        byte[] endBytes = endInclusive ? ByteComparator.MAX_BYTES : ByteComparator.MIN_BYTES;
        return new Itr(this.map.headMap(new Pair<Object, byte[]>(end, endBytes), endInclusive).descendingMap().entrySet().iterator());
    }

    @Override
    public CloseableIterator<IndexMap.IndexEntry> descendingIterator() {
        return new Itr(this.map.descendingMap().entrySet().iterator());
    }

    @Override
    public CloseableIterator<CachedDeserializable> keyIterator(Object start, boolean startInclusive, Object end, boolean endInclusive) {
        byte[] startBytes = startInclusive ? ByteComparator.MIN_BYTES : ByteComparator.MAX_BYTES;
        byte[] endBytes = endInclusive ? ByteComparator.MAX_BYTES : ByteComparator.MIN_BYTES;
        return new KeyItr(this.map.subMap(new Pair<Object, byte[]>(start, startBytes), startInclusive, new Pair<Object, byte[]>(end, endBytes), endInclusive).entrySet().iterator());
    }

    @Override
    public CloseableIterator<CachedDeserializable> keyIterator(Object start, boolean startInclusive) {
        byte[] startBytes = startInclusive ? ByteComparator.MIN_BYTES : ByteComparator.MAX_BYTES;
        return new KeyItr(this.map.tailMap(new Pair<Object, byte[]>(start, startBytes), startInclusive).entrySet().iterator());
    }

    @Override
    public CloseableIterator<CachedDeserializable> keyIterator() {
        return new KeyItr(this.map.entrySet().iterator());
    }

    @Override
    public CloseableIterator<CachedDeserializable> descendingKeyIterator(Object end, boolean endInclusive) {
        byte[] endBytes = endInclusive ? ByteComparator.MAX_BYTES : ByteComparator.MIN_BYTES;
        return new KeyItr(this.map.headMap(new Pair<Object, byte[]>(end, endBytes), endInclusive).descendingMap().entrySet().iterator());
    }

    @Override
    public CloseableIterator<CachedDeserializable> descendingKeyIterator() {
        return new KeyItr(this.map.descendingMap().entrySet().iterator());
    }

    @Override
    public long size(Object start, Object end) {
        byte[] startBytes = ByteComparator.MIN_BYTES;
        byte[] endBytes = ByteComparator.MAX_BYTES;
        return this.map.subMap(new Pair<Object, byte[]>(start, startBytes), new Pair<Object, byte[]>(end, endBytes)).size();
    }

    @Override
    public long sizeToEnd(Object start) {
        byte[] startBytes = ByteComparator.MIN_BYTES;
        return this.map.tailMap(new Pair<Object, byte[]>(start, startBytes)).size();
    }

    @Override
    public long sizeFromStart(Object end) {
        byte[] endBytes = ByteComparator.MAX_BYTES;
        return this.map.headMap(new Pair<Object, byte[]>(end, endBytes)).size();
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public void destroy() {
    }

    private CachedDeserializable toDeserializable(Object value) {
        if (value instanceof CachedDeserializable) {
            return (CachedDeserializable)value;
        }
        return new PreferBytesCachedDeserializable(value);
    }

    private static class KeyItr
    implements CloseableIterator<CachedDeserializable> {
        private final Iterator<Map.Entry<Pair<CachedDeserializable, CachedDeserializable>, CachedDeserializable>> iterator;

        public KeyItr(Iterator<Map.Entry<Pair<CachedDeserializable, CachedDeserializable>, CachedDeserializable>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public CachedDeserializable next() {
            Map.Entry<Pair<CachedDeserializable, CachedDeserializable>, CachedDeserializable> next = this.iterator.next();
            return next.getKey().getY();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }

    private static class Itr
    implements CloseableIterator<IndexMap.IndexEntry> {
        private final Iterator<Map.Entry<Pair<CachedDeserializable, CachedDeserializable>, CachedDeserializable>> iterator;

        public Itr(Iterator<Map.Entry<Pair<CachedDeserializable, CachedDeserializable>, CachedDeserializable>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public IndexMap.IndexEntry next() {
            Map.Entry<Pair<CachedDeserializable, CachedDeserializable>, CachedDeserializable> next = this.iterator.next();
            return new IndexEntryImpl(next.getKey().getX(), next.getKey().getY(), next.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }

    private static class IndexEntryImpl
    implements IndexMap.IndexEntry {
        private final CachedDeserializable indexKey;
        private final CachedDeserializable regionKey;
        private final CachedDeserializable value;

        public IndexEntryImpl(CachedDeserializable indexKey, CachedDeserializable regionKey, CachedDeserializable value) {
            this.indexKey = indexKey;
            this.regionKey = regionKey;
            this.value = value;
        }

        @Override
        public CachedDeserializable getKey() {
            return this.indexKey;
        }

        @Override
        public CachedDeserializable getRegionKey() {
            return this.regionKey;
        }

        @Override
        public CachedDeserializable getValue() {
            return this.value;
        }
    }
}

