/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Member;
import org.apache.geode.internal.cache.partitioned.rebalance.model.PartitionedRegionLoadModel;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;

public class Bucket
implements Comparable<Bucket> {
    private final int id;
    private final Set<Member> membersHosting = new TreeSet<Member>();
    private final Set<PersistentMemberID> offlineMembers;
    private float load;
    private long bytes;
    private float primaryLoad;
    private int redundancy = -1;
    private Member primary;

    public Bucket(int id) {
        this(id, 0.0f, 0L, new HashSet<PersistentMemberID>());
    }

    public Bucket(int id, float load, long bytes, Set<PersistentMemberID> offlineMembers) {
        this.id = id;
        this.load = load;
        this.bytes = bytes;
        this.offlineMembers = offlineMembers;
    }

    void changeLoad(float change) {
        this.load += change;
    }

    void changePrimaryLoad(float change) {
        this.primaryLoad += change;
    }

    void changeBytes(long change) {
        this.bytes += change;
    }

    void addOfflineMembers(Collection<? extends PersistentMemberID> members) {
        this.offlineMembers.addAll(members);
    }

    public void setPrimary(Member member, float primaryLoad) {
        if (this.primary == PartitionedRegionLoadModel.INVALID_MEMBER) {
            return;
        }
        if (this.primary != null) {
            this.primary.removePrimary(this);
        }
        this.primary = member;
        this.primaryLoad = primaryLoad;
        if (this.primary != PartitionedRegionLoadModel.INVALID_MEMBER && this.primary != null) {
            this.addMember(this.primary);
            member.addPrimary(this);
        }
    }

    public boolean addMember(Member targetMember) {
        if (this.getMembersHosting().add(targetMember)) {
            ++this.redundancy;
            targetMember.addBucket(this);
            return true;
        }
        return false;
    }

    public boolean removeMember(Member targetMember) {
        if (this.getMembersHosting().remove(targetMember)) {
            if (targetMember == this.primary) {
                this.setPrimary(null, 0.0f);
            }
            --this.redundancy;
            targetMember.removeBucket(this);
            return true;
        }
        return false;
    }

    public int getRedundancy() {
        return this.redundancy + this.offlineMembers.size();
    }

    public int getOnlineRedundancy() {
        return this.redundancy;
    }

    public float getLoad() {
        return this.load;
    }

    public int getId() {
        return this.id;
    }

    public long getBytes() {
        return this.bytes;
    }

    public String toString() {
        return "Bucket(id=" + this.getId() + ",load=" + this.load + ")";
    }

    public float getPrimaryLoad() {
        return this.primaryLoad;
    }

    public Set<Member> getMembersHosting() {
        return this.membersHosting;
    }

    public Member getPrimary() {
        return this.primary;
    }

    public Collection<? extends PersistentMemberID> getOfflineMembers() {
        return this.offlineMembers;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Bucket)) {
            return false;
        }
        Bucket o = (Bucket)other;
        return this.id == o.id;
    }

    @Override
    public int compareTo(Bucket other) {
        return Integer.compare(this.id, other.id);
    }
}

