/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;

public class ColocatedRegionDetails
implements DataSerializable {
    private String host;
    private String member;
    private String parent;
    private String child;

    public ColocatedRegionDetails(String host, String member, String parent, String child) {
        this.host = host;
        this.member = member;
        this.parent = parent;
        this.child = child;
    }

    public ColocatedRegionDetails() {
    }

    public String getHost() {
        return this.host;
    }

    public String getMember() {
        return this.member;
    }

    public String getParent() {
        return this.parent;
    }

    public String getChild() {
        return this.child;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        boolean hasChild;
        boolean hasParent;
        boolean hasMember;
        boolean hasHost = in.readBoolean();
        if (hasHost) {
            this.host = DataSerializer.readString(in);
        }
        if (hasMember = in.readBoolean()) {
            this.member = DataSerializer.readString(in);
        }
        if (hasParent = in.readBoolean()) {
            this.parent = DataSerializer.readString(in);
        }
        if (hasChild = in.readBoolean()) {
            this.child = DataSerializer.readString(in);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeBoolean(this.host != null);
        if (this.host != null) {
            DataSerializer.writeString(this.host, out);
        }
        out.writeBoolean(this.member != null);
        if (this.member != null) {
            DataSerializer.writeString(this.member, out);
        }
        out.writeBoolean(this.parent != null);
        if (this.parent != null) {
            DataSerializer.writeString(this.parent, out);
        }
        out.writeBoolean(this.child != null);
        if (this.child != null) {
            DataSerializer.writeString(this.child, out);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        if (this.host != null) {
            result.append("host:" + this.host);
        }
        if (this.member != null) {
            result.append(", member:" + this.member);
        } else {
            result.append(",");
        }
        if (this.parent != null) {
            result.append(", parent:" + this.parent);
        } else {
            result.append(",");
        }
        if (this.child != null) {
            result.append(", child:" + this.child);
        } else {
            result.append(",");
        }
        result.append("]");
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.member == null ? 0 : this.member.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColocatedRegionDetails other = (ColocatedRegionDetails)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.member == null ? other.member != null : !this.member.equals(other.member)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.child == null) {
            return other.child == null;
        }
        return this.child.equals(other.child);
    }
}

