/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.eviction.AbstractEvictionController;
import org.apache.geode.internal.cache.eviction.CachedDeserializableValueWrapper;
import org.apache.geode.internal.cache.eviction.EvictionCounters;
import org.apache.geode.internal.size.Sizeable;

abstract class SizeLRUController
extends AbstractEvictionController {
    private int perEntryOverhead;
    private final ObjectSizer sizer;

    SizeLRUController(EvictionCounters evictionCounters, EvictionAction evictionAction, ObjectSizer sizer, EvictionAlgorithm algorithm) {
        super(evictionCounters, evictionAction, algorithm);
        this.sizer = sizer;
    }

    public int getPerEntryOverhead() {
        return this.perEntryOverhead;
    }

    @Override
    public void setPerEntryOverhead(int entryOverhead) {
        this.perEntryOverhead = entryOverhead;
    }

    int sizeof(Object object) {
        boolean cdChangingForm = object instanceof CachedDeserializableValueWrapper;
        if (cdChangingForm) {
            object = ((CachedDeserializableValueWrapper)object).getValue();
        }
        if (object == null || object == Token.INVALID || object == Token.LOCAL_INVALID || object == Token.DESTROYED || object == Token.TOMBSTONE) {
            return 0;
        }
        int size = object instanceof byte[] || object instanceof String ? ObjectSizer.DEFAULT.sizeof(object) : (object instanceof Sizeable ? ((Sizeable)object).getSizeInBytes() : (this.sizer != null ? this.sizer.sizeof(object) : ObjectSizer.DEFAULT.sizeof(object)));
        if (cdChangingForm) {
            size += CachedDeserializableFactory.overhead();
        }
        return size;
    }
}

