/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.UnmodifiableException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.LockServiceDestroyedException;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.config.ClusterConfigurationNotAvailableException;
import org.apache.geode.internal.deployment.JarDeploymentService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.beans.FileUploader;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.functions.DownloadJarFunction;
import org.apache.geode.management.internal.configuration.functions.GetClusterConfigurationFunction;
import org.apache.geode.management.internal.configuration.messages.ConfigurationResponse;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.logging.log4j.Logger;

public class ClusterConfigurationLoader {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    private static final Function GET_CLUSTER_CONFIG_FUNCTION = new GetClusterConfigurationFunction();

    public void deployJarsReceivedFromClusterConfiguration(ConfigurationResponse response) throws IOException, ClassNotFoundException {
        if (response == null) {
            return;
        }
        logger.info("deploying jars received from cluster configuration");
        List jarFileNames = response.getJarNames().values().stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        if (!jarFileNames.isEmpty()) {
            logger.info("Got response with jars: {}", (Object)String.join((CharSequence)",", jarFileNames));
            JarDeploymentService jarDeploymentService = ClassPathLoader.getLatest().getJarDeploymentService();
            Set<File> stagedJarFiles = this.getJarsFromLocator(response.getMember(), response.getJarNames());
            for (File file : stagedJarFiles) {
                logger.info("Removing old versions of {} in cluster configuration.", (Object)file.getName());
                jarDeploymentService.undeployByFileName(file.getName());
                jarDeploymentService.deploy(file);
                logger.info("Deployed: {}", (Object)file.getAbsolutePath());
            }
        }
    }

    private Set<File> getJarsFromLocator(DistributedMember locator, Map<String, Set<String>> jarNames) throws IOException {
        HashMap<String, File> results = new HashMap<String, File>();
        for (String group : jarNames.keySet()) {
            for (String jar : jarNames.get(group)) {
                results.put(jar, this.downloadJar(locator, group, jar));
            }
        }
        return new HashSet<File>(results.values());
    }

    public File downloadJar(DistributedMember locator, String groupName, String jarName) throws IOException {
        Path tempDir = FileUploader.createSecuredTempDirectory("deploy-");
        Path tempJar = Paths.get(tempDir.toString(), jarName);
        this.downloadTo(locator, groupName, jarName, tempJar);
        return tempJar.toFile();
    }

    void downloadTo(DistributedMember locator, String groupName, String jarName, Path jarPath) throws IOException {
        ResultCollector<?, ?> rc = ManagementUtils.executeFunction(new DownloadJarFunction(), new Object[]{groupName, jarName}, Collections.singleton(locator));
        List result = (List)rc.getResult();
        if (result.get(0) instanceof Throwable) {
            throw new IllegalStateException(((Throwable)result.get(0)).getMessage());
        }
        FileOutputStream fos = new FileOutputStream(jarPath.toString());
        InputStream jarStream = RemoteInputStreamClient.wrap((RemoteInputStream)result.get(0));
        IOUtils.copyLarge((InputStream)jarStream, (OutputStream)fos);
        fos.close();
        jarStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyClusterXmlConfiguration(Cache cache, ConfigurationResponse response, String groupList) {
        String cacheXmlContent;
        if (response == null || response.getRequestedConfiguration().isEmpty()) {
            return;
        }
        Set<String> groups = this.getGroups(groupList);
        Map<String, Configuration> requestedConfiguration = response.getRequestedConfiguration();
        LinkedList<String> cacheXmlContentList = new LinkedList<String>();
        Configuration clusterConfiguration = requestedConfiguration.get("cluster");
        if (clusterConfiguration != null && StringUtils.isNotBlank((CharSequence)(cacheXmlContent = clusterConfiguration.getCacheXmlContent()))) {
            cacheXmlContentList.add(cacheXmlContent);
        }
        for (String group : groups) {
            String cacheXmlContent2;
            Configuration groupConfiguration = requestedConfiguration.get(group);
            if (groupConfiguration == null || !StringUtils.isNotBlank((CharSequence)(cacheXmlContent2 = groupConfiguration.getCacheXmlContent()))) continue;
            cacheXmlContentList.add(cacheXmlContent2);
        }
        for (String cacheXmlContent3 : cacheXmlContentList) {
            ByteArrayInputStream is = new ByteArrayInputStream(cacheXmlContent3.getBytes());
            try {
                cache.loadCacheXml(is);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void applyClusterPropertiesConfiguration(ConfigurationResponse response, DistributionConfig config) {
        if (response == null || response.getRequestedConfiguration().isEmpty()) {
            return;
        }
        Set<String> groups = this.getGroups(config.getGroups());
        Map<String, Configuration> requestedConfiguration = response.getRequestedConfiguration();
        Properties runtimeProps = new Properties();
        Configuration clusterConfiguration = requestedConfiguration.get("cluster");
        if (clusterConfiguration != null) {
            runtimeProps.putAll((Map<?, ?>)clusterConfiguration.getGemfireProperties());
        }
        Properties groupProps = new Properties();
        for (String group : groups) {
            Configuration groupConfiguration = requestedConfiguration.get(group);
            if (groupConfiguration == null) continue;
            for (Map.Entry<Object, Object> e : groupConfiguration.getGemfireProperties().entrySet()) {
                if (groupProps.containsKey(e.getKey())) {
                    logger.warn("Conflicting property {} from group {}", e.getKey(), (Object)group);
                    continue;
                }
                groupProps.put(e.getKey(), e.getValue());
            }
        }
        runtimeProps.putAll((Map<?, ?>)groupProps);
        Set<Object> attNames = runtimeProps.keySet();
        for (Object attNameObj : attNames) {
            String attName = (String)attNameObj;
            String attValue = runtimeProps.getProperty(attName);
            try {
                config.setAttribute(attName, attValue, ConfigSource.runtime());
            }
            catch (IllegalArgumentException e) {
                logger.info(e.getMessage());
            }
            catch (UnmodifiableException e) {
                logger.info(e.getMessage());
            }
        }
    }

    public ConfigurationResponse requestConfigurationFromLocators(String groupList, Set<InternalDistributedMember> locatorList) throws ClusterConfigurationNotAvailableException, UnknownHostException {
        Set<String> groups = this.getGroups(groupList);
        ConfigurationResponse response = null;
        block2: for (int attempts = 6; attempts > 0; --attempts) {
            for (InternalDistributedMember locator : locatorList) {
                logger.info("Attempting to retrieve cluster configuration from {} - {} attempts remaining", (Object)locator.getName(), (Object)attempts);
                response = this.requestConfigurationFromOneLocator(locator, groups);
                if (response == null) continue;
                break block2;
            }
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException ex) {
                break;
            }
        }
        if (response == null) {
            throw new ClusterConfigurationNotAvailableException("Unable to retrieve cluster configuration from the locator.");
        }
        return response;
    }

    protected ConfigurationResponse requestConfigurationFromOneLocator(InternalDistributedMember locator, Set<String> groups) {
        ConfigurationResponse configResponse;
        block6: {
            configResponse = null;
            try {
                ResultCollector resultCollector = FunctionService.onMember(locator).setArguments(groups).execute(GET_CLUSTER_CONFIG_FUNCTION);
                Object result = ((ArrayList)resultCollector.getResult()).get(0);
                if (result instanceof ConfigurationResponse) {
                    configResponse = (ConfigurationResponse)result;
                    configResponse.setMember(locator);
                } else {
                    if (result != null) {
                        logger.error("Received invalid result from {}: {}", (Object)locator.toString(), result);
                    }
                    if (result instanceof Throwable) {
                        logger.error(result.toString(), result);
                    }
                }
            }
            catch (FunctionException fex) {
                if (fex.getCause() instanceof LockServiceDestroyedException || fex.getCause() instanceof FunctionInvocationTargetException) break block6;
                throw fex;
            }
        }
        return configResponse;
    }

    Set<String> getGroups(String groupString) {
        if (StringUtils.isBlank((CharSequence)groupString)) {
            return new HashSet<String>();
        }
        return Arrays.stream(groupString.split(",")).collect(Collectors.toSet());
    }
}

